/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGoogleAsyncWriteChannel<T extends AbstractGoogleClientRequest<S>, S>
implements WritableByteChannel {
    public static final int UPLOAD_PIPE_BUFFER_SIZE_DEFAULT = 0x100000;
    public static final int GCS_UPLOAD_GRANULARITY = 0x800000;
    public static final int UPLOAD_CHUNK_SIZE_DEFAULT = Runtime.getRuntime().maxMemory() < 0x20000000L ? 0x800000 : 0x4000000;
    private String contentType;
    private static final long UPLOAD_MAX_SIZE = 267361714176L;
    private ClientRequestHelper<S> clientRequestHelper = new ClientRequestHelper();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGoogleAsyncWriteChannel.class);
    private PipedOutputStream pipeSink;
    private PipedInputStream pipeSource;
    private ExecutorService threadPool;
    private boolean isInitialized = false;
    @VisibleForTesting
    private int uploadBufferSize = UPLOAD_CHUNK_SIZE_DEFAULT;
    private int pipeBufferSize = 0x100000;
    private WritableByteChannel pipeSinkChannel;
    private Future<S> uploadOperation;
    @VisibleForTesting
    private boolean limitFileSizeTo250Gb = false;
    private boolean directUploadEnabled = false;

    @VisibleForTesting
    public void setClientRequestHelper(ClientRequestHelper<S> helper) {
        this.clientRequestHelper = helper;
    }

    public AbstractGoogleAsyncWriteChannel(ExecutorService threadPool, AsyncWriteChannelOptions options) {
        this.threadPool = threadPool;
        this.enableFileSizeLimit250Gb(options.isFileSizeLimitedTo250Gb());
        this.setUploadBufferSize(options.getUploadBufferSize());
        this.setDirectUploadEnabled(options.isDirectUploadEnabled());
        this.setContentType("application/octet-stream");
    }

    public abstract T createRequest(InputStreamContent var1) throws IOException;

    public void handleResponse(S response) throws IOException {
    }

    public S createResponseFromException(IOException ioe) {
        return null;
    }

    public void setUploadBufferSize(int bufferSize) {
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Upload buffer size must be great than 0.");
        Preconditions.checkArgument((bufferSize % 262144 == 0 ? 1 : 0) != 0, (Object)"Upload buffer size must be a multiple of MediaHttpUploader.MINIMUM_CHUNK_SIZE");
        if (bufferSize > 0x800000 && bufferSize % 0x800000 != 0) {
            LOG.warn("Upload buffer size should be a multiple of {} for best performance, got {}", (Object)0x800000, (Object)bufferSize);
        }
        this.uploadBufferSize = bufferSize;
    }

    public void enableFileSizeLimit250Gb(boolean enableLimit) {
        this.limitFileSizeTo250Gb = enableLimit;
    }

    public void setDirectUploadEnabled(boolean enableDirectUpload) {
        this.directUploadEnabled = enableDirectUpload;
    }

    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    @Override
    public synchronized int write(ByteBuffer buffer) throws IOException {
        this.throwIfNotInitialized();
        this.throwIfNotOpen();
        if (this.uploadOperation.isDone()) {
            this.waitForCompletionAndThrowIfUploadFailed();
        }
        return this.pipeSinkChannel.write(buffer);
    }

    @Override
    public boolean isOpen() {
        return this.pipeSinkChannel != null && this.pipeSinkChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.throwIfNotInitialized();
        if (this.isOpen()) {
            try {
                this.pipeSinkChannel.close();
                this.handleResponse(this.waitForCompletionAndThrowIfUploadFailed());
            }
            finally {
                this.pipeSinkChannel = null;
                this.pipeSink = null;
                this.pipeSource = null;
                this.uploadOperation = null;
            }
        }
    }

    public void initialize() throws IOException {
        this.pipeSource = new PipedInputStream(this.pipeBufferSize);
        this.pipeSink = new PipedOutputStream(this.pipeSource);
        this.pipeSinkChannel = Channels.newChannel(this.pipeSink);
        InputStreamContent objectContentStream = new InputStreamContent(this.contentType, (InputStream)this.pipeSource);
        objectContentStream.setLength(-1L);
        objectContentStream.setCloseInputStream(false);
        T request = this.createRequest(objectContentStream);
        request.setDisableGZipContent(true);
        HttpHeaders headers = this.clientRequestHelper.getRequestHeaders((AbstractGoogleClientRequest<S>)request);
        headers.set("X-Goog-Upload-Desired-Chunk-Granularity", (Object)Math.min(0x800000, this.uploadBufferSize));
        if (this.limitFileSizeTo250Gb) {
            headers.set("X-Goog-Upload-Max-Raw-Size", (Object)267361714176L);
        }
        this.clientRequestHelper.setChunkSize((AbstractGoogleClientRequest<S>)request, this.uploadBufferSize);
        this.uploadOperation = this.threadPool.submit(new UploadOperation(this, request, (InputStream)this.pipeSource));
        this.isInitialized = true;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private void throwIfNotOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private S waitForCompletionAndThrowIfUploadFailed() throws IOException {
        try {
            return this.uploadOperation.get();
        }
        catch (InterruptedException e) {
            this.uploadOperation.cancel(true);
            ClosedByInterruptException exception = new ClosedByInterruptException();
            exception.addSuppressed(e);
            throw exception;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    private void throwIfNotInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("initialize() must be invoked before use.");
        }
    }

    static class UploadOperation
    implements Callable<S> {
        private final T uploadObject;
        private final InputStream pipeSource;
        final /* synthetic */ AbstractGoogleAsyncWriteChannel this$0;

        public UploadOperation(T uploadObject, InputStream pipeSource) {
            this.this$0 = this$0;
            this.uploadObject = uploadObject;
            this.pipeSource = pipeSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public S call() throws Exception {
            Exception exception = null;
            try {
                Object object = this.uploadObject.execute();
                return object;
            }
            catch (IOException ioe) {
                exception = ioe;
                Object response = this.this$0.createResponseFromException(ioe);
                if (response != null) {
                    LOG.warn(String.format("Received IOException, but successfully converted to response '%s'.", response), (Throwable)ioe);
                    Object s = response;
                    return s;
                }
                LOG.error("Exception not convertible into handled response", (Throwable)ioe);
            }
            catch (Exception e) {
                exception = e;
                LOG.error("Exception uploading. ", (Throwable)e);
            }
            finally {
                try {
                    this.pipeSource.close();
                }
                catch (IOException ioe) {
                    LOG.error("Error trying to close pipe.source()", (Throwable)ioe);
                    if (exception != null) {
                        exception.addSuppressed(ioe);
                    }
                    exception = ioe;
                }
            }
            throw exception;
        }
    }
}

