package com.google.cloud.hadoop.util;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AsyncWriteChannelOptions extends AsyncWriteChannelOptions {

  private final int bufferSize;

  private final int pipeBufferSize;

  private final AsyncWriteChannelOptions.PipeType pipeType;

  private final int uploadChunkSize;

  private final int uploadCacheSize;

  private final boolean directUploadEnabled;

  private final boolean grpcChecksumsEnabled;

  private final long grpcWriteTimeout;

  private final long numberOfBufferedRequests;

  private final long grpcWriteMessageTimeoutMillis;

  private AutoValue_AsyncWriteChannelOptions(
      int bufferSize,
      int pipeBufferSize,
      AsyncWriteChannelOptions.PipeType pipeType,
      int uploadChunkSize,
      int uploadCacheSize,
      boolean directUploadEnabled,
      boolean grpcChecksumsEnabled,
      long grpcWriteTimeout,
      long numberOfBufferedRequests,
      long grpcWriteMessageTimeoutMillis) {
    this.bufferSize = bufferSize;
    this.pipeBufferSize = pipeBufferSize;
    this.pipeType = pipeType;
    this.uploadChunkSize = uploadChunkSize;
    this.uploadCacheSize = uploadCacheSize;
    this.directUploadEnabled = directUploadEnabled;
    this.grpcChecksumsEnabled = grpcChecksumsEnabled;
    this.grpcWriteTimeout = grpcWriteTimeout;
    this.numberOfBufferedRequests = numberOfBufferedRequests;
    this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
  }

  @Override
  public int getBufferSize() {
    return bufferSize;
  }

  @Override
  public int getPipeBufferSize() {
    return pipeBufferSize;
  }

  @Override
  public AsyncWriteChannelOptions.PipeType getPipeType() {
    return pipeType;
  }

  @Override
  public int getUploadChunkSize() {
    return uploadChunkSize;
  }

  @Override
  public int getUploadCacheSize() {
    return uploadCacheSize;
  }

  @Override
  public boolean isDirectUploadEnabled() {
    return directUploadEnabled;
  }

  @Override
  public boolean isGrpcChecksumsEnabled() {
    return grpcChecksumsEnabled;
  }

  @Override
  public long getGrpcWriteTimeout() {
    return grpcWriteTimeout;
  }

  @Override
  public long getNumberOfBufferedRequests() {
    return numberOfBufferedRequests;
  }

  @Override
  public long getGrpcWriteMessageTimeoutMillis() {
    return grpcWriteMessageTimeoutMillis;
  }

  @Override
  public String toString() {
    return "AsyncWriteChannelOptions{"
        + "bufferSize=" + bufferSize + ", "
        + "pipeBufferSize=" + pipeBufferSize + ", "
        + "pipeType=" + pipeType + ", "
        + "uploadChunkSize=" + uploadChunkSize + ", "
        + "uploadCacheSize=" + uploadCacheSize + ", "
        + "directUploadEnabled=" + directUploadEnabled + ", "
        + "grpcChecksumsEnabled=" + grpcChecksumsEnabled + ", "
        + "grpcWriteTimeout=" + grpcWriteTimeout + ", "
        + "numberOfBufferedRequests=" + numberOfBufferedRequests + ", "
        + "grpcWriteMessageTimeoutMillis=" + grpcWriteMessageTimeoutMillis
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AsyncWriteChannelOptions) {
      AsyncWriteChannelOptions that = (AsyncWriteChannelOptions) o;
      return this.bufferSize == that.getBufferSize()
          && this.pipeBufferSize == that.getPipeBufferSize()
          && this.pipeType.equals(that.getPipeType())
          && this.uploadChunkSize == that.getUploadChunkSize()
          && this.uploadCacheSize == that.getUploadCacheSize()
          && this.directUploadEnabled == that.isDirectUploadEnabled()
          && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled()
          && this.grpcWriteTimeout == that.getGrpcWriteTimeout()
          && this.numberOfBufferedRequests == that.getNumberOfBufferedRequests()
          && this.grpcWriteMessageTimeoutMillis == that.getGrpcWriteMessageTimeoutMillis();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= bufferSize;
    h$ *= 1000003;
    h$ ^= pipeBufferSize;
    h$ *= 1000003;
    h$ ^= pipeType.hashCode();
    h$ *= 1000003;
    h$ ^= uploadChunkSize;
    h$ *= 1000003;
    h$ ^= uploadCacheSize;
    h$ *= 1000003;
    h$ ^= directUploadEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcChecksumsEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((grpcWriteTimeout >>> 32) ^ grpcWriteTimeout);
    h$ *= 1000003;
    h$ ^= (int) ((numberOfBufferedRequests >>> 32) ^ numberOfBufferedRequests);
    h$ *= 1000003;
    h$ ^= (int) ((grpcWriteMessageTimeoutMillis >>> 32) ^ grpcWriteMessageTimeoutMillis);
    return h$;
  }

  @Override
  public AsyncWriteChannelOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AsyncWriteChannelOptions.Builder {
    private int bufferSize;
    private int pipeBufferSize;
    private AsyncWriteChannelOptions.PipeType pipeType;
    private int uploadChunkSize;
    private int uploadCacheSize;
    private boolean directUploadEnabled;
    private boolean grpcChecksumsEnabled;
    private long grpcWriteTimeout;
    private long numberOfBufferedRequests;
    private long grpcWriteMessageTimeoutMillis;
    private short set$0;
    Builder() {
    }
    private Builder(AsyncWriteChannelOptions source) {
      this.bufferSize = source.getBufferSize();
      this.pipeBufferSize = source.getPipeBufferSize();
      this.pipeType = source.getPipeType();
      this.uploadChunkSize = source.getUploadChunkSize();
      this.uploadCacheSize = source.getUploadCacheSize();
      this.directUploadEnabled = source.isDirectUploadEnabled();
      this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
      this.grpcWriteTimeout = source.getGrpcWriteTimeout();
      this.numberOfBufferedRequests = source.getNumberOfBufferedRequests();
      this.grpcWriteMessageTimeoutMillis = source.getGrpcWriteMessageTimeoutMillis();
      set$0 = (short) 0x1ff;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setBufferSize(int bufferSize) {
      this.bufferSize = bufferSize;
      set$0 |= 1;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPipeBufferSize(int pipeBufferSize) {
      this.pipeBufferSize = pipeBufferSize;
      set$0 |= 2;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setPipeType(AsyncWriteChannelOptions.PipeType pipeType) {
      if (pipeType == null) {
        throw new NullPointerException("Null pipeType");
      }
      this.pipeType = pipeType;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setUploadChunkSize(int uploadChunkSize) {
      this.uploadChunkSize = uploadChunkSize;
      set$0 |= 4;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setUploadCacheSize(int uploadCacheSize) {
      this.uploadCacheSize = uploadCacheSize;
      set$0 |= 8;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setDirectUploadEnabled(boolean directUploadEnabled) {
      this.directUploadEnabled = directUploadEnabled;
      set$0 |= 0x10;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
      this.grpcChecksumsEnabled = grpcChecksumsEnabled;
      set$0 |= 0x20;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setGrpcWriteTimeout(long grpcWriteTimeout) {
      this.grpcWriteTimeout = grpcWriteTimeout;
      set$0 |= 0x40;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setNumberOfBufferedRequests(long numberOfBufferedRequests) {
      this.numberOfBufferedRequests = numberOfBufferedRequests;
      set$0 |= 0x80;
      return this;
    }
    @Override
    public AsyncWriteChannelOptions.Builder setGrpcWriteMessageTimeoutMillis(long grpcWriteMessageTimeoutMillis) {
      this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
      set$0 |= 0x100;
      return this;
    }
    @Override
    AsyncWriteChannelOptions autoBuild() {
      if (set$0 != 0x1ff
          || this.pipeType == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" bufferSize");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" pipeBufferSize");
        }
        if (this.pipeType == null) {
          missing.append(" pipeType");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" uploadChunkSize");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" uploadCacheSize");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" directUploadEnabled");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" grpcChecksumsEnabled");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" grpcWriteTimeout");
        }
        if ((set$0 & 0x80) == 0) {
          missing.append(" numberOfBufferedRequests");
        }
        if ((set$0 & 0x100) == 0) {
          missing.append(" grpcWriteMessageTimeoutMillis");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AsyncWriteChannelOptions(
          this.bufferSize,
          this.pipeBufferSize,
          this.pipeType,
          this.uploadChunkSize,
          this.uploadCacheSize,
          this.directUploadEnabled,
          this.grpcChecksumsEnabled,
          this.grpcWriteTimeout,
          this.numberOfBufferedRequests,
          this.grpcWriteMessageTimeoutMillis);
    }
  }

}
