/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.IoExceptionHelper;
import com.google.common.truth.Truth;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import javax.net.ssl.SSLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiErrorExtractorTest {
    private GoogleJsonResponseException accessDenied;
    private GoogleJsonResponseException statusOk;
    private GoogleJsonResponseException notFound;
    private GoogleJsonResponseException badRange;
    private GoogleJsonResponseException alreadyExists;
    private GoogleJsonResponseException rateLimited;
    private GoogleJsonResponseException notRateLimited;
    private GoogleJsonResponseException quotaExceeded;
    private GoogleJsonResponseException resourceNotReady;
    private GoogleJsonResponseException bigqueryRateLimited;
    private static final int POSSIBLE_RATE_LIMIT = 429;
    private final ApiErrorExtractor errorExtractor = ApiErrorExtractor.INSTANCE;

    @Before
    public void setUp() throws Exception {
        this.accessDenied = ApiErrorExtractorTest.googleJsonResponseException(403, "Forbidden", "Forbidden");
        this.statusOk = ApiErrorExtractorTest.googleJsonResponseException(200, "A reason", "ok");
        this.notFound = ApiErrorExtractorTest.googleJsonResponseException(404, "Not found", "Not found");
        this.badRange = ApiErrorExtractorTest.googleJsonResponseException(416, "Bad range", "Bad range");
        this.alreadyExists = ApiErrorExtractorTest.googleJsonResponseException(409, "409", "409");
        this.resourceNotReady = ApiErrorExtractorTest.googleJsonResponseException(400, "resourceNotReady", "Resource not ready");
        GoogleJsonError.ErrorInfo errorInfo = new GoogleJsonError.ErrorInfo();
        errorInfo.setReason("rateLimitExceeded");
        this.notRateLimited = ApiErrorExtractorTest.googleJsonResponseException(429, errorInfo, "");
        errorInfo.setDomain("usageLimits");
        this.rateLimited = ApiErrorExtractorTest.googleJsonResponseException(429, errorInfo, "");
        errorInfo.setDomain("global");
        this.bigqueryRateLimited = ApiErrorExtractorTest.googleJsonResponseException(429, errorInfo, "");
        errorInfo.setReason("quotaExceeded");
        this.quotaExceeded = ApiErrorExtractorTest.googleJsonResponseException(429, errorInfo, "");
    }

    @Test
    public void testAccessDenied() {
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied((IOException)this.accessDenied)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied(new IOException((Throwable)this.accessDenied))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied(new IOException(new IOException((Throwable)this.accessDenied)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied((IOException)this.statusOk)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.accessDenied(new IOException((Throwable)this.statusOk))).isFalse();
    }

    @Test
    public void testItemAlreadyExists() {
        Truth.assertThat((Boolean)this.errorExtractor.itemAlreadyExists((IOException)this.alreadyExists)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.itemAlreadyExists(new IOException((Throwable)this.alreadyExists))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.itemAlreadyExists(new IOException(new IOException((Throwable)this.alreadyExists)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.itemAlreadyExists((IOException)this.statusOk)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.itemAlreadyExists(new IOException((Throwable)this.statusOk))).isFalse();
    }

    @Test
    public void testItemNotFound() {
        Truth.assertThat((Boolean)this.errorExtractor.itemNotFound((IOException)this.notFound)).isTrue();
        GoogleJsonError gje = new GoogleJsonError();
        gje.setCode(404);
        Truth.assertThat((Boolean)this.errorExtractor.itemNotFound(new IOException((Throwable)this.notFound))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.itemNotFound(new IOException(new IOException((Throwable)this.notFound)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.itemNotFound((IOException)this.statusOk)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.itemNotFound(new IOException())).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.itemNotFound(new IOException(new IOException()))).isFalse();
    }

    @Test
    public void testRangeNotSatisfiable() {
        Truth.assertThat((Boolean)this.errorExtractor.rangeNotSatisfiable((IOException)this.badRange)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rangeNotSatisfiable(new IOException((Throwable)this.badRange))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rangeNotSatisfiable(new IOException(new IOException((Throwable)this.badRange)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rangeNotSatisfiable((IOException)this.statusOk)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.rangeNotSatisfiable((IOException)this.notFound)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.rangeNotSatisfiable(new IOException((Throwable)this.notFound))).isFalse();
    }

    @Test
    public void testRateLimited() {
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited((IOException)this.rateLimited)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited(new IOException((Throwable)this.rateLimited))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited(new IOException(new IOException((Throwable)this.rateLimited)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited((IOException)this.notRateLimited)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited(new IOException((Throwable)this.notRateLimited))).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited(new IOException((Throwable)this.statusOk))).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited(null)).isFalse();
    }

    @Test
    public void testQuotaExceeded() {
        Truth.assertThat((Boolean)this.errorExtractor.quotaExceeded((IOException)this.quotaExceeded)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.quotaExceeded(new IOException((Throwable)this.quotaExceeded))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.quotaExceeded(new IOException(new IOException((Throwable)this.quotaExceeded)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.quotaExceeded((IOException)this.statusOk)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.quotaExceeded(new IOException())).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.quotaExceeded(new IOException(new IOException()))).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.quotaExceeded(null)).isFalse();
    }

    @Test
    public void testBigQueryRateLimited() {
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited((IOException)this.bigqueryRateLimited)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited(new IOException((Throwable)this.bigqueryRateLimited))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited(new IOException(new IOException((Throwable)this.bigqueryRateLimited)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.rateLimited((IOException)this.notRateLimited)).isFalse();
    }

    @Test
    public void testIOError() {
        EOFException ioError1 = new EOFException("io error 1");
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)ioError1)).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)new Exception(ioError1))).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)new RuntimeException(new RuntimeException(ioError1)))).isTrue();
        IOException ioError2 = new IOException("io error 2");
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)ioError2)).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)new Exception(ioError2))).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)new RuntimeException(new RuntimeException(ioError2)))).isTrue();
        IOError ioError3 = new IOError(new Exception("io error 3"));
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)ioError3)).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)new Exception(ioError3))).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)new RuntimeException(new RuntimeException(ioError3)))).isTrue();
        Exception notIOError = new Exception("not io error");
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)notIOError)).isFalse();
        Truth.assertThat((Boolean)IoExceptionHelper.isIoError((Throwable)new RuntimeException(notIOError))).isFalse();
    }

    @Test
    public void testSocketError() {
        SocketTimeoutException socketError1 = new SocketTimeoutException("socket error 1");
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)socketError1)).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new Exception(socketError1))).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new IOException(new IOException(socketError1)))).isTrue();
        SocketException socketError2 = new SocketException("socket error 2");
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)socketError2)).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new Exception(socketError2))).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new IOException(new IOException(socketError2)))).isTrue();
        SSLException socketError3 = new SSLException("ssl exception", new EOFException("eof"));
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)socketError3)).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new Exception(socketError3))).isTrue();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new IOException(new IOException(socketError3)))).isTrue();
        Exception notSocketError = new Exception("not socket error");
        Exception notIOError = new Exception("not io error");
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)notSocketError)).isFalse();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new IOException(notSocketError))).isFalse();
        Truth.assertThat((Boolean)IoExceptionHelper.isSocketError((Throwable)new SSLException("handshake failed", notIOError))).isFalse();
    }

    @Test
    public void testReadTimedOut() {
        IOException x = new SocketTimeoutException("Read timed out");
        Truth.assertThat((Boolean)IoExceptionHelper.isReadTimedOut((IOException)x)).isTrue();
        x = new IOException("not a SocketTimeoutException");
        Truth.assertThat((Boolean)IoExceptionHelper.isReadTimedOut((IOException)x)).isFalse();
        x = new SocketTimeoutException("not the right kind of timeout");
        Truth.assertThat((Boolean)IoExceptionHelper.isReadTimedOut((IOException)x)).isFalse();
    }

    @Test
    public void testResourceNotReady() {
        Truth.assertThat((Boolean)this.errorExtractor.resourceNotReady((IOException)this.resourceNotReady)).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.resourceNotReady(new IOException((Throwable)this.resourceNotReady))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.resourceNotReady(new IOException(new IOException((Throwable)this.resourceNotReady)))).isTrue();
        Truth.assertThat((Boolean)this.errorExtractor.resourceNotReady((IOException)this.statusOk)).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.resourceNotReady(new IOException((Throwable)this.statusOk))).isFalse();
        Truth.assertThat((Boolean)this.errorExtractor.resourceNotReady(null)).isFalse();
    }

    @Test
    public void testGetErrorMessage() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(42, "Detail Reason", "Detail message", "Top Level HTTP Message");
        Truth.assertThat((String)this.errorExtractor.getErrorMessage((IOException)withJsonError)).isEqualTo((Object)"Top Level HTTP Message");
        GoogleJsonResponseException nullJsonErrorWithMessage = ApiErrorExtractorTest.googleJsonResponseException(42, null, null, "Top Level HTTP Message");
        Truth.assertThat((String)this.errorExtractor.getErrorMessage((IOException)nullJsonErrorWithMessage)).isEqualTo((Object)"Top Level HTTP Message");
    }

    @Test
    public void accessDeniedNonRecoverable_GoogleJsonErrorWithAccountDisabledReturnTrue() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(403, "accountDisabled", "Forbidden", "Forbidden");
        Truth.assertThat((Boolean)this.errorExtractor.accessDeniedNonRecoverable((IOException)withJsonError)).isTrue();
    }

    @Test
    public void accessDeniedNonRecoverable_GoogleJsonErrorWithAccessNotConfiguredReturnTrue() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(403, "accessNotConfigured", "Forbidden", "Forbidden");
        Truth.assertThat((Boolean)this.errorExtractor.accessDeniedNonRecoverable((IOException)withJsonError)).isTrue();
    }

    @Test
    public void accessDeniedNonRecoverable_GoogleJsonErrorWithStatusOkReturnFalse() {
        Truth.assertThat((Boolean)this.errorExtractor.accessDeniedNonRecoverable((IOException)this.statusOk)).isFalse();
    }

    @Test
    public void accessDeniedNonRecoverable_GoogleJsonErrorAsNullReturnFalse() {
        Truth.assertThat((Boolean)this.errorExtractor.accessDeniedNonRecoverable(null)).isFalse();
    }

    @Test
    public void isClientError_GoogleJsonErrorWithAccessDeniedReturnTrue() {
        Truth.assertThat((Boolean)this.errorExtractor.clientError((IOException)this.accessDenied)).isTrue();
    }

    @Test
    public void isClientError_GoogleJsonErrorWithStatusBadGatewayReturnFalse() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(502, "Bad gateway", "Bad gateway", "Bad gateway");
        Truth.assertThat((Boolean)this.errorExtractor.clientError((IOException)withJsonError)).isFalse();
    }

    @Test
    public void isClientError_GoogleJsonErrorAsNullReturnFalse() {
        Truth.assertThat((Boolean)this.errorExtractor.clientError(null)).isFalse();
    }

    @Test
    public void isInternalServerError_GoogleJsonErrorWithAccessDeniedReturnFalse() {
        Truth.assertThat((Boolean)this.errorExtractor.internalServerError((IOException)this.accessDenied)).isFalse();
    }

    @Test
    public void isInternalServerError_GoogleJsonErrorWithStatusBadGatewayReturnTrue() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(502, "Bad gateway", "Bad gateway", "Bad gateway");
        Truth.assertThat((Boolean)this.errorExtractor.internalServerError((IOException)withJsonError)).isTrue();
    }

    @Test
    public void isInternalServerError_GoogleJsonErrorAsNullReturnFalse() {
        Truth.assertThat((Boolean)this.errorExtractor.internalServerError(null)).isFalse();
    }

    @Test
    public void fieldSizeTooLarge_GoogleJsonErrorWithStatusOkReturnFalse() {
        Truth.assertThat((Boolean)this.errorExtractor.fieldSizeTooLarge(new IOException((Throwable)this.statusOk))).isFalse();
    }

    @Test
    public void fieldSizeTooLarge_GoogleJsonErrorWithFieldSizeTooLargeReturnTrue() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(413, "fieldSizeTooLarge", "Value for field 'foo' is too large", "Value for field 'foo' is too large");
        Truth.assertThat((Boolean)this.errorExtractor.fieldSizeTooLarge((IOException)withJsonError)).isTrue();
    }

    @Test
    public void fieldSizeTooLarge_GoogleJsonErrorAsNullReturnFalse() {
        Truth.assertThat((Boolean)this.errorExtractor.fieldSizeTooLarge(null)).isFalse();
    }

    @Test
    public void preconditionNotMet_GoogleJsonErrorHttpStatusPreconditionFailedTrue() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(412, "preconditionNotMet", "Precondition not met", "Precondition not met");
        Truth.assertThat((Boolean)this.errorExtractor.preconditionNotMet((IOException)withJsonError)).isTrue();
    }

    @Test
    public void userProjectMissing_GoogleJsonErrorAsNullReturnFalse() throws IOException {
        GoogleJsonResponseException withJsonError = ApiErrorExtractorTest.googleJsonResponseException(400, "preconditionNotMet", "Precondition not met", "Precondition not met");
        Truth.assertThat((Boolean)this.errorExtractor.userProjectMissing((IOException)withJsonError)).isFalse();
    }

    @Test
    public void userProjectMissing_GoogleJsonErrorWithStatusOkReturnFalse() throws IOException {
        GoogleJsonResponseException nullJsonError = ApiErrorExtractorTest.googleJsonResponseException(42, null, null, null);
        Truth.assertThat((Boolean)this.errorExtractor.userProjectMissing((IOException)nullJsonError)).isFalse();
    }

    @Test
    public void toUserPresentableException() {
        String action = "foo";
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> this.errorExtractor.toUserPresentableException((IOException)this.accessDenied, action));
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)String.format("Encountered an error while %s: Forbidden", action));
    }

    @Test
    public void toUserPresentableException_actionAsNull() {
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> this.errorExtractor.toUserPresentableException((IOException)this.accessDenied, null));
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)"Forbidden");
    }

    @Test
    public void testToUserPresentableMessage() {
        Truth.assertThat((String)this.errorExtractor.toUserPresentableMessage(new IOException((Throwable)this.accessDenied))).isEqualTo((Object)"Forbidden");
    }

    @Test
    public void getDebugInfo_accessDeniedReturnNull() {
        Truth.assertThat((String)this.errorExtractor.getDebugInfo(new IOException((Throwable)this.accessDenied))).isNull();
    }

    private static GoogleJsonResponseException googleJsonResponseException(int httpStatus, String reason, String message) throws IOException {
        return ApiErrorExtractorTest.googleJsonResponseException(httpStatus, reason, message, message);
    }

    private static GoogleJsonResponseException googleJsonResponseException(int httpStatus, String reason, String message, String httpStatusString) throws IOException {
        GoogleJsonError.ErrorInfo errorInfo = new GoogleJsonError.ErrorInfo();
        errorInfo.setReason(reason);
        errorInfo.setMessage(message);
        return ApiErrorExtractorTest.googleJsonResponseException(httpStatus, errorInfo, httpStatusString);
    }

    private static GoogleJsonResponseException googleJsonResponseException(int status, final GoogleJsonError.ErrorInfo errorInfo, String httpStatusString) throws IOException {
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        MockHttpTransport transport = new MockHttpTransport((JsonFactory)jsonFactory, status, httpStatusString){
            final /* synthetic */ JsonFactory val$jsonFactory;
            final /* synthetic */ int val$status;
            final /* synthetic */ String val$httpStatusString;
            {
                this.val$jsonFactory = jsonFactory;
                this.val$status = n;
                this.val$httpStatusString = string;
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                errorInfo.setFactory(this.val$jsonFactory);
                GoogleJsonError jsonError = new GoogleJsonError();
                jsonError.setCode(this.val$status);
                jsonError.setErrors(Collections.singletonList(errorInfo));
                jsonError.setMessage(this.val$httpStatusString);
                jsonError.setFactory(this.val$jsonFactory);
                GenericJson errorResponse = new GenericJson();
                errorResponse.set("error", (Object)jsonError);
                errorResponse.setFactory(this.val$jsonFactory);
                return new MockLowLevelHttpRequest().setResponse(new MockLowLevelHttpResponse().setContent(errorResponse.toPrettyString()).setContentType("application/json; charset=UTF-8").setStatusCode(this.val$status));
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        return GoogleJsonResponseException.from((JsonFactory)jsonFactory, (HttpResponse)response);
    }
}

