/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import javax.net.ssl.SSLSocketFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HttpTransportFactoryTest {
    private static final FakeSslSocketFactory FAKE_SOCKET_FACTORY = new FakeSslSocketFactory();
    private static final String[] SUPPORTED_CIPHER_SUITES = new String[]{"testSuite"};
    private static final String[] DEFAULT_CIPHER_SUITES = new String[]{"testDefaultCipherSuite"};

    @Test
    public void testParseProxyAddress() throws Exception {
        String address = "foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI(null, "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressHttp() throws Exception {
        String address = "http://foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI("http", "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressHttps() throws Exception {
        String address = "https://foo-host:1234";
        URI expectedUri = HttpTransportFactoryTest.getURI("https", "foo-host", 1234);
        URI uri = HttpTransportFactory.parseProxyAddress((String)address);
        Truth.assertThat((Comparable)uri).isEqualTo((Object)expectedUri);
    }

    @Test
    public void testParseProxyAddressInvalidScheme() throws Exception {
        String address = "socks5://foo-host:1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"HTTP proxy address 'socks5://foo-host:1234' has invalid scheme 'socks5'.");
    }

    @Test
    public void testParseProxyAddressNoHost() throws Exception {
        String address = ":1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Proxy address ':1234' has no host.");
    }

    @Test
    public void testParseProxyAddressNoPort() throws Exception {
        String address = "foo-host";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Proxy address 'foo-host' has no port.");
    }

    @Test
    public void testParseProxyAddressInvalidSyntax() throws Exception {
        String address = "foo-host-with-illegal-char^:1234";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Invalid proxy address 'foo-host-with-illegal-char^:1234'.");
    }

    @Test
    public void testParseProxyAddressWithPath() throws Exception {
        String address = "foo-host:1234/some/path";
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> HttpTransportFactory.parseProxyAddress((String)address));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Invalid proxy address 'foo-host:1234/some/path'.");
    }

    @Test
    public void testCustomSslSocketFactoryDefaultCipherSuites() {
        HttpTransportFactory.CustomSslSocketFactory customSslSocketFactory = new HttpTransportFactory.CustomSslSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY, null);
        Truth.assertThat((Object[])customSslSocketFactory.getDefaultCipherSuites()).isEqualTo((Object)DEFAULT_CIPHER_SUITES);
    }

    @Test
    public void testCustomSslSocketFactorySupportedCipherSuites() {
        HttpTransportFactory.CustomSslSocketFactory customSslSocketFactory = new HttpTransportFactory.CustomSslSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY, null);
        Truth.assertThat((Object[])customSslSocketFactory.getSupportedCipherSuites()).isEqualTo((Object)SUPPORTED_CIPHER_SUITES);
    }

    @Test
    public void testCustomSslSocketFactoryIsNotCorrupted() throws GeneralSecurityException, IOException {
        NetHttpTransport.Builder builder = HttpTransportFactory.createNetHttpTransportBuilder(null, null);
        Truth.assertThat((Object)builder.getSslSocketFactory()).isInstanceOf(HttpTransportFactory.CustomSslSocketFactory.class);
    }

    @Test
    public void testCustomSslSocketFactoryKeepAliveTrue() throws IOException {
        HttpTransportFactory.CustomSslSocketFactory customSslSocketFactory = new HttpTransportFactory.CustomSslSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY, null);
        HttpTransportFactoryTest.checkSocket((SSLSocketFactory)customSslSocketFactory, socket -> Truth.assertThat((Boolean)socket.getKeepAlive()).isTrue());
    }

    @Test
    public void testCustomSslSocketFactoryNoReadTimeout() throws IOException {
        HttpTransportFactory.CustomSslSocketFactory customSslSocketFactory = new HttpTransportFactory.CustomSslSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY, null);
        HttpTransportFactoryTest.checkSocket((SSLSocketFactory)customSslSocketFactory, socket -> Truth.assertThat((Integer)socket.getSoTimeout()).isEqualTo((Object)0));
    }

    @Test
    public void testCustomSslSocketFactorySetReadTimeout() throws IOException {
        Duration readTimeout = Duration.ofMillis(20000L);
        HttpTransportFactory.CustomSslSocketFactory customSslSocketFactory = new HttpTransportFactory.CustomSslSocketFactory((SSLSocketFactory)FAKE_SOCKET_FACTORY, readTimeout);
        HttpTransportFactoryTest.checkSocket((SSLSocketFactory)customSslSocketFactory, socket -> Truth.assertThat((Integer)socket.getSoTimeout()).isEqualTo((Object)Math.toIntExact(readTimeout.toMillis())));
    }

    private static void checkSocket(SSLSocketFactory sslSocketFactory, SocketAssertion assertion) throws IOException {
        assertion.accept(sslSocketFactory.createSocket());
        assertion.accept(sslSocketFactory.createSocket(null, "localhost", 80, false));
        assertion.accept(sslSocketFactory.createSocket(null, null, false));
        assertion.accept(sslSocketFactory.createSocket("localhost", 80));
        assertion.accept(sslSocketFactory.createSocket("localhost", 80, null, 443));
        InetAddress fakeInet = InetAddress.getByName("10.0.0.0");
        assertion.accept(sslSocketFactory.createSocket(fakeInet, 443));
        assertion.accept(sslSocketFactory.createSocket(fakeInet, 443, fakeInet, 80));
    }

    private static URI getURI(String scheme, String host, int port) throws URISyntaxException {
        return new URI(scheme, null, host, port, null, null, null);
    }

    @FunctionalInterface
    private static interface SocketAssertion {
        public void accept(Socket var1) throws IOException;
    }

    private static class FakeSslSocketFactory
    extends SSLSocketFactory {
        private FakeSslSocketFactory() {
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return DEFAULT_CIPHER_SUITES;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return SUPPORTED_CIPHER_SUITES;
        }

        @Override
        public Socket createSocket() {
            return new Socket();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(Socket socket, InputStream inputStream, boolean b) throws IOException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.createSocket();
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.createSocket();
        }
    }
}

