/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.RetryHttpInitializerOptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class RetryHttpInitializerTest {
    @Mock
    private Credential mockCredential;
    @Mock
    private LowLevelHttpRequest mockLowLevelRequest;
    @Mock
    private LowLevelHttpResponse mockLowLevelResponse;
    @Mock
    private Sleeper mockSleeper;
    private HttpRequestFactory requestFactory;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        MockHttpTransport fakeTransport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) {
                return RetryHttpInitializerTest.this.mockLowLevelRequest;
            }
        };
        RetryHttpInitializer initializer = new RetryHttpInitializer(this.mockCredential, RetryHttpInitializerOptions.builder().setDefaultUserAgent("foo-user-agent").setHttpHeaders((Map)ImmutableMap.of((Object)"header-key", (Object)"header=value")).setMaxRequestRetries(10).setConnectTimeout(Duration.ofMillis(20000L)).setReadTimeout(Duration.ofMillis(20000L)).build());
        initializer.setSleeperOverride(this.mockSleeper);
        this.requestFactory = fakeTransport.createRequestFactory((HttpRequestInitializer)initializer);
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockCredential});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSleeper});
    }

    @Test
    public void testConstructorNullCredential() {
        new RetryHttpInitializer(null, "foo-user-agent");
    }

    @Test
    public void testBasicOperation() throws IOException {
        String authHeaderValue = "Bearer a1b2c3d4";
        HttpRequest req = this.requestFactory.buildGetRequest(new GenericUrl("http://fake-url.com"));
        Truth.assertThat((String)req.getHeaders().getUserAgent()).isEqualTo((Object)"foo-user-agent");
        Truth.assertThat((Object)req.getHeaders().get((Object)"header-key")).isEqualTo((Object)"header=value");
        Truth.assertThat((Object)((RetryHttpInitializer)this.requestFactory.getInitializer()).getCredential()).isEqualTo((Object)this.mockCredential);
        ((Credential)Mockito.doAnswer(unused -> {
            req.getHeaders().setAuthorization("Bearer a1b2c3d4");
            return null;
        }).when((Object)this.mockCredential)).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        Mockito.when((Object)this.mockLowLevelRequest.execute()).thenReturn((Object)this.mockLowLevelResponse);
        Mockito.when((Object)this.mockLowLevelResponse.getStatusCode()).thenReturn((Object)200);
        HttpResponse res = req.execute();
        Truth.assertThat((Object)res).isNotNull();
        ((Credential)Mockito.verify((Object)this.mockCredential)).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest)).addHeader((String)ArgumentMatchers.eq((Object)"Authorization"), (String)ArgumentMatchers.eq((Object)"Bearer a1b2c3d4"));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest)).execute();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.mockLowLevelResponse, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)200);
    }

    @Test
    public void testErrorCodeForbidden() throws IOException {
        String authHeaderValue = "Bearer a1b2c3d4";
        HttpRequest req = this.requestFactory.buildGetRequest(new GenericUrl("http://fake-url.com"));
        Truth.assertThat((String)req.getHeaders().getUserAgent()).isEqualTo((Object)"foo-user-agent");
        ((Credential)Mockito.doAnswer(unused -> {
            req.getHeaders().setAuthorization("Bearer a1b2c3d4");
            return null;
        }).doAnswer(unused -> {
            req.getHeaders().setAuthorization("Bearer a1b2c3d4");
            return null;
        }).when((Object)this.mockCredential)).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        Mockito.when((Object)this.mockLowLevelRequest.execute()).thenReturn((Object)this.mockLowLevelResponse).thenReturn((Object)this.mockLowLevelResponse);
        Mockito.when((Object)this.mockLowLevelResponse.getStatusCode()).thenReturn((Object)403).thenReturn((Object)403).thenReturn((Object)200);
        Mockito.when((Object)this.mockCredential.handleResponse((HttpRequest)ArgumentMatchers.eq((Object)req), (HttpResponse)ArgumentMatchers.any(HttpResponse.class), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)true);
        HttpResponse res = req.execute();
        Truth.assertThat((Object)res).isNotNull();
        ((Credential)Mockito.verify((Object)this.mockCredential, (VerificationMode)Mockito.times((int)2))).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest, (VerificationMode)Mockito.times((int)2))).addHeader((String)ArgumentMatchers.eq((Object)"Authorization"), (String)ArgumentMatchers.eq((Object)"Bearer a1b2c3d4"));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest, (VerificationMode)Mockito.times((int)2))).execute();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.mockLowLevelResponse, (VerificationMode)Mockito.times((int)4))).getStatusCode();
        ((Credential)Mockito.verify((Object)this.mockCredential)).handleResponse((HttpRequest)ArgumentMatchers.eq((Object)req), (HttpResponse)ArgumentMatchers.any(HttpResponse.class), ArgumentMatchers.eq((boolean)true));
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
    }

    @Test
    public void testErrorCodeTransientServerError() throws Exception {
        this.testRetriesForErrorCode(503);
    }

    @Test
    public void testErrorCodeRateLimitExceeded() throws Exception {
        this.testRetriesForErrorCode(429);
    }

    private void testRetriesForErrorCode(int code) throws Exception {
        String authHeaderValue = "Bearer a1b2c3d4";
        HttpRequest req = this.requestFactory.buildGetRequest(new GenericUrl("http://fake-url.com"));
        Truth.assertThat((String)req.getHeaders().getUserAgent()).isEqualTo((Object)"foo-user-agent");
        ((Credential)Mockito.doAnswer(unused -> {
            req.getHeaders().setAuthorization("Bearer a1b2c3d4");
            return null;
        }).doAnswer(unused -> {
            req.getHeaders().setAuthorization("Bearer a1b2c3d4");
            return null;
        }).when((Object)this.mockCredential)).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        Mockito.when((Object)this.mockLowLevelRequest.execute()).thenReturn((Object)this.mockLowLevelResponse).thenReturn((Object)this.mockLowLevelResponse);
        Mockito.when((Object)this.mockLowLevelResponse.getStatusCode()).thenReturn((Object)code).thenReturn((Object)code).thenReturn((Object)200);
        Mockito.when((Object)this.mockCredential.handleResponse((HttpRequest)ArgumentMatchers.eq((Object)req), (HttpResponse)ArgumentMatchers.any(HttpResponse.class), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)false);
        HttpResponse res = req.execute();
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
        Truth.assertThat((Object)res).isNotNull();
        ((Credential)Mockito.verify((Object)this.mockCredential, (VerificationMode)Mockito.times((int)2))).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest, (VerificationMode)Mockito.times((int)2))).addHeader((String)ArgumentMatchers.eq((Object)"Authorization"), (String)ArgumentMatchers.eq((Object)"Bearer a1b2c3d4"));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest, (VerificationMode)Mockito.times((int)2))).execute();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.mockLowLevelResponse, (VerificationMode)Mockito.times((int)4))).getStatusCode();
        ((Credential)Mockito.verify((Object)this.mockCredential)).handleResponse((HttpRequest)ArgumentMatchers.eq((Object)req), (HttpResponse)ArgumentMatchers.any(HttpResponse.class), ArgumentMatchers.eq((boolean)true));
        ((Sleeper)Mockito.verify((Object)this.mockSleeper)).sleep(ArgumentMatchers.anyLong());
    }

    @Test
    public void testThrowIOException() throws Exception {
        String authHeaderValue = "Bearer a1b2c3d4";
        HttpRequest req = this.requestFactory.buildGetRequest(new GenericUrl("http://fake-url.com"));
        Truth.assertThat((String)req.getHeaders().getUserAgent()).isEqualTo((Object)"foo-user-agent");
        ((Credential)Mockito.doAnswer(unused -> {
            req.getHeaders().setAuthorization("Bearer a1b2c3d4");
            return null;
        }).doAnswer(unused -> {
            req.getHeaders().setAuthorization("Bearer a1b2c3d4");
            return null;
        }).when((Object)this.mockCredential)).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        Mockito.when((Object)this.mockLowLevelRequest.execute()).thenThrow(new Throwable[]{new IOException("fake IOException")}).thenReturn((Object)this.mockLowLevelResponse);
        Mockito.when((Object)this.mockLowLevelResponse.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.mockCredential.handleResponse((HttpRequest)ArgumentMatchers.eq((Object)req), (HttpResponse)ArgumentMatchers.any(HttpResponse.class), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)false);
        HttpResponse res = req.execute();
        Truth.assertThat((String)((String)req.getHeaders().get((Object)"x-goog-api-client"))).contains((CharSequence)"gccl-invocation-id/");
        Truth.assertThat((Object)res).isNotNull();
        ((Credential)Mockito.verify((Object)this.mockCredential, (VerificationMode)Mockito.times((int)2))).intercept((HttpRequest)ArgumentMatchers.eq((Object)req));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest, (VerificationMode)Mockito.times((int)2))).addHeader((String)ArgumentMatchers.eq((Object)"Authorization"), (String)ArgumentMatchers.eq((Object)"Bearer a1b2c3d4"));
        ((LowLevelHttpRequest)Mockito.verify((Object)this.mockLowLevelRequest, (VerificationMode)Mockito.times((int)2))).execute();
        ((LowLevelHttpResponse)Mockito.verify((Object)this.mockLowLevelResponse, (VerificationMode)Mockito.times((int)2))).getStatusCode();
        ((Sleeper)Mockito.verify((Object)this.mockSleeper)).sleep(ArgumentMatchers.anyLong());
    }
}

