/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.ThreadTrace;
import com.google.common.truth.Truth;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ThreadTraceTest {
    private ThreadTrace threadTrace;
    private List<ThreadTrace.ThreadTraceEvent> events;
    private String key1;
    private String key2;
    private String val1;
    private Map<Long, List<ThreadTrace.ThreadTraceEvent>> subEvents;

    @Before
    public void before() throws Exception {
        this.threadTrace = new ThreadTrace("some");
        this.key1 = ThreadTraceTest.getRandomVal();
        this.key2 = ThreadTraceTest.getRandomVal();
        this.val1 = ThreadTraceTest.getRandomVal();
        this.events = (List)this.getPrivateField("events").get(this.threadTrace);
        this.subEvents = (Map)this.getPrivateField("subEvents").get(this.threadTrace);
    }

    private Field getPrivateField(String fieldName) throws NoSuchFieldException {
        Field eventsField = this.threadTrace.getClass().getDeclaredField(fieldName);
        eventsField.setAccessible(true);
        return eventsField;
    }

    @Test
    public void null_trackingId_throws() {
        Assert.assertThrows(NullPointerException.class, () -> new ThreadTrace(null));
    }

    @Test
    public void annotate_emtpy_event_ignored() {
        this.threadTrace.annotate(this.key1, (Object)this.val1);
        Truth.assertThat(this.events).hasSize(0);
    }

    @Test
    public void annotate_adds_to_last() {
        ThreadTrace.ThreadTraceEvent threadTraceEvent = this.threadTrace.starOperationEvent(ThreadTraceTest.getRandomVal());
        Truth.assertThat(this.events).hasSize(1);
        Truth.assertThat((Map)((Map)this.events.get(0))).isEqualTo((Object)threadTraceEvent);
        Truth.assertThat((Object)threadTraceEvent.get((Object)this.key1)).isNull();
        this.threadTrace.annotate(this.key1, (Object)this.val1);
        Truth.assertThat((Object)threadTraceEvent.get((Object)this.key1)).isEqualTo((Object)this.val1);
    }

    @Test
    public void max_annotate_limit_test() {
        ThreadTrace.ThreadTraceEvent threadTraceEvent = this.threadTrace.starOperationEvent(ThreadTraceTest.getRandomVal());
        for (int i = 0; i < 7; ++i) {
            String theKey = Integer.toString(i);
            String theVal = ThreadTraceTest.getRandomVal();
            this.threadTrace.annotate(theKey, (Object)theVal);
            Truth.assertThat((Object)threadTraceEvent.get((Object)theKey)).isEqualTo((Object)theVal);
        }
        this.threadTrace.annotate(this.key1, (Object)this.val1);
        Truth.assertThat((Object)threadTraceEvent.get((Object)this.key1)).isNull();
    }

    @Test
    public void no_events_added_when_full() {
        for (int i = 0; i < 20; ++i) {
            Truth.assertThat((Map)this.threadTrace.starOperationEvent(ThreadTraceTest.getRandomVal())).isNotNull();
            Truth.assertThat(this.events).hasSize(i + 1);
        }
        Truth.assertThat((Map)this.threadTrace.starOperationEvent(ThreadTraceTest.getRandomVal())).isNull();
        Truth.assertThat(this.events).hasSize(20);
    }

    @Test
    public void end_operation_event_when_full() {
        for (int i = 0; i < 19; ++i) {
            Truth.assertThat((Map)this.threadTrace.starOperationEvent(ThreadTraceTest.getRandomVal())).isNotNull();
            Truth.assertThat(this.events).hasSize(i + 1);
        }
        ThreadTrace.ThreadTraceEvent ss = this.threadTrace.starOperationEvent(ThreadTraceTest.getRandomVal());
        Truth.assertThat(this.events).hasSize(20);
        this.threadTrace.endOperationEvent(ss);
        Truth.assertThat(this.events).hasSize(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sub_trace_udpates_parent() throws ExecutionException, InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(1);
        try {
            Truth.assertThat(this.subEvents).hasSize(0);
            for (int i = 1; i < 20; ++i) {
                long threadId = this.submitSubTask(service);
                Truth.assertThat(this.subEvents).hasSize(1);
                List<ThreadTrace.ThreadTraceEvent> singleThreadEvents = this.subEvents.get(threadId);
                Truth.assertThat(singleThreadEvents).hasSize(i);
            }
            long threadId = this.submitSubTask(service);
            List<ThreadTrace.ThreadTraceEvent> singleThreadEvents = this.subEvents.get(threadId);
            Truth.assertThat(singleThreadEvents).hasSize(20);
        }
        finally {
            service.shutdown();
        }
    }

    private Long submitSubTask(ExecutorService service) throws InterruptedException, ExecutionException {
        return service.submit(() -> {
            ThreadTrace subTrace = this.threadTrace.getSubTrace();
            ThreadTrace.ThreadTraceEvent start = subTrace.starOperationEvent("some");
            subTrace.endOperationEvent(start);
            return Thread.currentThread().getId();
        }).get();
    }

    static String getRandomVal() {
        return String.format("rand-%d", ThreadLocalRandom.current().nextInt());
    }
}

