/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.util.GcsJsonApiEvent;
import com.google.cloud.hadoop.util.GoogleCloudStorageEventBus;
import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.flogger.GoogleLogger;
import java.util.concurrent.TimeUnit;

public class RequestTracker {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final long LOGGING_THRESHOLD = 300L;
    private Stopwatch stopWatch;
    private Object context;
    private int retryCount;
    private long backOffTime;
    private HttpRequest request;
    private final long startTime = System.currentTimeMillis();
    private boolean initialized;

    protected RequestTracker() {
    }

    public static RequestTracker create(HttpRequest request) {
        return new RequestTracker();
    }

    void trackResponse(HttpResponse response) {
        if (this.stopWatch.isRunning()) {
            this.postToEventQueue(GcsJsonApiEvent.getResponseEvent(response, this.stopWatch.elapsed().toMillis(), this.context));
            this.stopTracking();
        }
        if (this.retryCount != 0) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).atMostEvery(10, TimeUnit.SECONDS)).log("Operation completed after retries with code '%s'. %s", response.getStatusCode(), (Object)this);
        }
    }

    void trackIOException() {
        this.stopTracking();
        this.postToEventQueue(GcsJsonApiEvent.getExceptionEvent(this.request, this.context));
    }

    void trackUnsuccessfulResponseHandler(HttpResponse response) {
        this.stopTracking();
        this.postToEventQueue(GcsJsonApiEvent.getResponseEvent(response, this.stopWatch.elapsed().toMillis(), this.context));
    }

    void trackBackOffCompleted(long backOffStartTime) {
        long diff = System.currentTimeMillis() - backOffStartTime;
        this.postToEventQueue(GcsJsonApiEvent.getBackoffEvent(this.request, diff, this.retryCount, this.context));
        this.backOffTime += diff;
    }

    void trackRetryStarted() {
        this.stopWatch.reset();
        this.stopWatch.start();
        ++this.retryCount;
    }

    void trackRetrySkipped(boolean hasResponse) {
        if (!hasResponse && this.retryCount != 0) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).atMostEvery(10, TimeUnit.SECONDS)).log("Retry skipped after %s retries. context=%s", this.retryCount, (Object)this);
        }
    }

    protected void postToEventQueue(GcsJsonApiEvent event) {
        GoogleCloudStorageEventBus.postGcsJsonApiEvent(event);
    }

    public RequestTracker init(HttpRequest request) {
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        this.stopWatch = Stopwatch.createStarted();
        this.context = new RequestContext(request);
        this.request = request;
        this.postToEventQueue(GcsJsonApiEvent.getRequestStartedEvent(request, this.context));
        return this;
    }

    private void stopTracking() {
        if (this.stopWatch.isRunning()) {
            this.stopWatch.stop();
            if (this.stopWatch.elapsed().toMillis() > 300L) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).atMostEvery(10, TimeUnit.SECONDS)).log("Detected high latency for %s. durationMs=%s; method=%s; thread=%s", this.context, (Object)this.stopWatch.elapsed().toMillis(), (Object)this.request.getRequestMethod(), (Object)Thread.currentThread().getName());
            }
        } else {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(1, TimeUnit.MINUTES)).log("Can stop only an already executing request. details=%s", (Object)this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("retryCount", this.retryCount).add("totalBackoffTimeMs", this.backOffTime).add("context", this.context).add("method", (Object)this.request.getRequestMethod()).add("elapsedMs", System.currentTimeMillis() - this.startTime).toString();
    }

    private static class RequestContext {
        private final HttpRequest request;

        public RequestContext(HttpRequest request) {
            this.request = request;
        }

        public String toString() {
            return String.format("[url=%s; invocationId=%s]", this.request.getUrl(), this.request.getHeaders().get((Object)"x-goog-api-client"));
        }
    }
}

