/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.beam.CloudBigtableScanConfiguration;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import com.google.cloud.bigtable.beam.sequencefiles.ExportJob;
import com.google.cloud.bigtable.beam.sequencefiles.ImportJob;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.read.DefaultReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ParseFilter;

public class TemplateUtils {
    public static CloudBigtableTableConfiguration BuildImportConfig(ImportJob.ImportOptions opts) {
        CloudBigtableTableConfiguration.Builder builder = new CloudBigtableTableConfiguration.Builder().withProjectId(opts.getBigtableProject()).withInstanceId(opts.getBigtableInstanceId()).withTableId(opts.getBigtableTableId());
        if (opts.getBigtableAppProfileId() != null) {
            builder.withAppProfileId(opts.getBigtableAppProfileId());
        }
        ValueProvider.NestedValueProvider enableThrottling = ValueProvider.NestedValueProvider.of(opts.getMutationThrottleLatencyMs(), (SerializableFunction & Serializable)throttleMs -> String.valueOf(throttleMs > 0));
        builder.withConfiguration("google.bigtable.buffered.mutator.throttling.enable", (ValueProvider)enableThrottling);
        builder.withConfiguration("google.bigtable.buffered.mutator.throttling.threshold.ms", (ValueProvider)ValueProvider.NestedValueProvider.of(opts.getMutationThrottleLatencyMs(), String::valueOf));
        return builder.build();
    }

    public static CloudBigtableScanConfiguration BuildExportConfig(ExportJob.ExportOptions opts) {
        RequestValueProvider request = new RequestValueProvider(opts.getBigtableStartRow(), opts.getBigtableStopRow(), opts.getBigtableMaxVersions(), opts.getBigtableFilter());
        CloudBigtableScanConfiguration.Builder configBuilder = new CloudBigtableScanConfiguration.Builder().withProjectId(opts.getBigtableProject()).withInstanceId(opts.getBigtableInstanceId()).withTableId(opts.getBigtableTableId()).withAppProfileId(opts.getBigtableAppProfileId()).withRequest((ValueProvider)request);
        return configBuilder.build();
    }

    private static class RequestValueProvider
    implements ValueProvider<ReadRowsRequest>,
    Serializable {
        private final ValueProvider<String> start;
        private final ValueProvider<String> stop;
        private final ValueProvider<Integer> maxVersion;
        private final ValueProvider<String> filter;
        private ReadRowsRequest cachedRequest;

        RequestValueProvider(ValueProvider<String> start, ValueProvider<String> stop, ValueProvider<Integer> maxVersion, ValueProvider<String> filter) {
            this.start = start;
            this.stop = stop;
            this.maxVersion = maxVersion;
            this.filter = filter;
        }

        public ReadRowsRequest get() {
            if (this.cachedRequest == null) {
                Scan scan = new Scan();
                if (this.start.get() != null && !((String)this.start.get()).isEmpty()) {
                    scan.setStartRow(((String)this.start.get()).getBytes());
                }
                if (this.stop.get() != null && !((String)this.stop.get()).isEmpty()) {
                    scan.setStopRow(((String)this.stop.get()).getBytes());
                }
                if (this.maxVersion.get() != null) {
                    scan.setMaxVersions(((Integer)this.maxVersion.get()).intValue());
                }
                if (this.filter.get() != null && !((String)this.filter.get()).isEmpty()) {
                    try {
                        scan.setFilter(new ParseFilter().parseFilterString((String)this.filter.get()));
                    }
                    catch (CharacterCodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                DefaultReadHooks readHooks = new DefaultReadHooks();
                ReadRowsRequest.Builder builder = Adapters.SCAN_ADAPTER.adapt(scan, (ReadHooks)readHooks);
                this.cachedRequest = readHooks.applyPreSendHook(builder.build());
            }
            return this.cachedRequest;
        }

        public boolean isAccessible() {
            return this.start.isAccessible() && this.stop.isAccessible() && this.maxVersion.isAccessible() && this.filter.isAccessible();
        }

        public String toString() {
            if (this.isAccessible()) {
                return String.valueOf(this.get());
            }
            return "Unavailable during pipeline construction";
        }
    }
}

