/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import com.google.cloud.bigtable.beam.sequencefiles.ImportJob;
import com.google.cloud.bigtable.beam.sequencefiles.SequenceFileSource;
import com.google.cloud.bigtable.beam.sequencefiles.Utils;
import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.values.KV;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

class CreateTableHelper {
    private static final Log LOG = LogFactory.getLog(CreateTableHelper.class);

    CreateTableHelper() {
    }

    public static void main(String[] args) throws Exception {
        PipelineOptionsFactory.register(CreateTableOpts.class);
        CreateTableOpts opts = (CreateTableOpts)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(CreateTableOpts.class);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)opts);
        CreateTableHelper.createTable(opts);
    }

    static void createTable(CreateTableOpts opts) throws Exception {
        LOG.info((Object)"Extracting splits from the source files");
        SequenceFileSource<ImmutableBytesWritable, Result> source = ImportJob.createSource((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)opts.getSourcePattern()));
        List splitSources = source.split(0x6400000L, (PipelineOptions)opts);
        byte[][] splits = (byte[][])((Stream)splitSources.stream().parallel()).map(splitSource -> {
            try {
                BoundedSource.BoundedReader reader = splitSource.createReader((PipelineOptions)opts);
                Throwable throwable = null;
                try {
                    if (!reader.start()) return null;
                    ImmutableBytesWritable immutableBytesWritable = (ImmutableBytesWritable)((KV)reader.getCurrent()).getKey();
                    return immutableBytesWritable;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        CreateTableHelper.$closeResource(throwable, (AutoCloseable)reader);
                    }
                }
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
            return null;
        }).filter(Objects::nonNull).sorted().map(ImmutableBytesWritable::copyBytes).toArray(x$0 -> new byte[x$0][]);
        LOG.info((Object)String.format("Creating a new table with %d splits and the families: %s", splits.length, opts.getFamilies()));
        try (Connection connection = BigtableConfiguration.connect((String)opts.getBigtableProject(), (String)opts.getBigtableInstanceId());){
            TableName tableName = TableName.valueOf((String)opts.getBigtableTableId());
            HTableDescriptor descriptor = new HTableDescriptor(tableName);
            for (String family : opts.getFamilies()) {
                descriptor.addFamily(new HColumnDescriptor(family));
            }
            connection.getAdmin().createTable(descriptor, splits);
        }
    }

    static interface CreateTableOpts
    extends GcpOptions {
        @Description(value="The project that contains the table to export. Defaults to --project.")
        @Default.InstanceFactory(value=Utils.DefaultBigtableProjectFactory.class)
        public String getBigtableProject();

        public void setBigtableProject(String var1);

        @Description(value="The Bigtable instance id that contains the table to export.")
        public String getBigtableInstanceId();

        public void setBigtableInstanceId(String var1);

        @Description(value="The Bigtable table id to export.")
        public String getBigtableTableId();

        public void setBigtableTableId(String var1);

        @Description(value="The fully qualified file pattern to import. Should of the form '[destinationPath]/part-*'")
        public String getSourcePattern();

        public void setSourcePattern(String var1);

        @Description(value="The families to add to the new table")
        public List<String> getFamilies();

        public void setFamilies(List<String> var1);
    }
}

