/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import com.google.api.client.util.Lists;
import com.google.cloud.bigtable.beam.sequencefiles.DataCellPredicateFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HBaseResultToMutationFn
extends DoFn<KV<ImmutableBytesWritable, Result>, Mutation> {
    private static Logger logger = LoggerFactory.getLogger(HBaseResultToMutationFn.class);
    private static final long serialVersionUID = 1L;
    private static final int MAX_CELLS = 100000;
    private static final Predicate<Cell> IS_DELETE_MARKER_FILTER = new Predicate<Cell>(){

        public boolean apply(Cell cell) {
            return CellUtil.isDelete((Cell)cell);
        }
    };
    private static final Function<Cell, String> COLUMN_FAMILY_EXTRACTOR = new Function<Cell, String>(){

        public String apply(Cell cell) {
            return Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell));
        }
    };
    private static final DataCellPredicateFactory DATA_CELL_PREDICATE_FACTORY = new DataCellPredicateFactory();
    private transient boolean isEmptyRowWarned;

    HBaseResultToMutationFn() {
    }

    @VisibleForTesting
    static void setLogger(Logger log) {
        logger = log;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) throws Exception {
        KV kv = (KV)context.element();
        List<Cell> cells = this.checkEmptyRow((KV<ImmutableBytesWritable, Result>)kv);
        if (cells.isEmpty()) {
            return;
        }
        if (this.hasDeleteMarkers(cells)) {
            cells = this.preprocessDeleteMarkers(cells);
        }
        Iterator<Cell> cellIt = cells.iterator();
        while (cellIt.hasNext()) {
            Put put = new Put(((ImmutableBytesWritable)kv.getKey()).get());
            for (int i = 0; i < 100000 && cellIt.hasNext(); ++i) {
                put.add(cellIt.next());
            }
            context.output((Object)put);
        }
    }

    private boolean hasDeleteMarkers(List<Cell> cells) {
        for (Cell cell : cells) {
            if (!CellUtil.isDelete((Cell)cell)) continue;
            return true;
        }
        return false;
    }

    private List<Cell> preprocessDeleteMarkers(List<Cell> cells) {
        ArrayList resultCells = Lists.newArrayList();
        ImmutableMap dataCellsByFamilyMap = Multimaps.index((Iterable)Iterables.filter(cells, (Predicate)Predicates.not(IS_DELETE_MARKER_FILTER)), COLUMN_FAMILY_EXTRACTOR).asMap();
        ImmutableMap deleteMarkersByFamilyMap = Multimaps.index((Iterable)Iterables.filter(cells, IS_DELETE_MARKER_FILTER), COLUMN_FAMILY_EXTRACTOR).asMap();
        for (Map.Entry e : dataCellsByFamilyMap.entrySet()) {
            this.processOneColumnFamily(resultCells, (Collection)e.getValue(), (Collection)deleteMarkersByFamilyMap.get(e.getKey()));
        }
        return resultCells;
    }

    private void processOneColumnFamily(List<Cell> resultCells, Collection<Cell> dataCells, Collection<Cell> deleteMarkers) {
        if (deleteMarkers == null) {
            resultCells.addAll(dataCells);
        } else {
            Predicate liveDataCellPredicate = Predicates.not((Predicate)Predicates.or((Iterable)Lists.newArrayList((Iterable)Iterables.transform(deleteMarkers, (Function)DATA_CELL_PREDICATE_FACTORY))));
            for (Cell cell : dataCells) {
                if (!liveDataCellPredicate.apply((Object)cell)) continue;
                resultCells.add(cell);
            }
        }
    }

    private List<Cell> checkEmptyRow(KV<ImmutableBytesWritable, Result> kv) {
        List<Cell> cells = ((Result)kv.getValue()).listCells();
        if (cells == null) {
            cells = Collections.emptyList();
        }
        if (!this.isEmptyRowWarned && cells.isEmpty()) {
            logger.warn("Encountered empty row. Was input file serialized by HBase 0.94?");
            this.isEmptyRowWarned = true;
        }
        return cells;
    }
}

