/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import avro.shaded.com.google.common.collect.Sets;
import com.google.cloud.bigtable.beam.sequencefiles.HadoopSerializationCoder;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.values.KV;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.util.ReflectionUtils;

class SequenceFileSource<K, V>
extends FileBasedSource<KV<K, V>> {
    private static final Log LOG = LogFactory.getLog(SequenceFileSource.class);
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final Class<? extends Serialization<? super K>> keySerializationClass;
    private final Class<? extends Serialization<? super V>> valueSerializationClass;
    private final KvCoder<K, V> coder;

    SequenceFileSource(ValueProvider<String> fileOrPatternSpec, Class<K> keyClass, Class<? extends Serialization<? super K>> keySerialization, Class<V> valueClass, Class<? extends Serialization<? super V>> valueSerialization, long minBundleSize) {
        super(fileOrPatternSpec, minBundleSize);
        Preconditions.checkArgument((minBundleSize >= 2000L ? 1 : 0) != 0, (Object)"minBundleSize must be at least 2000");
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.keySerializationClass = keySerialization;
        this.valueSerializationClass = valueSerialization;
        this.coder = KvCoder.of(new HadoopSerializationCoder<K>(keyClass, keySerialization), new HadoopSerializationCoder<V>(valueClass, valueSerialization));
    }

    private SequenceFileSource(MatchResult.Metadata fileMetadata, long startOffset, long endOffset, Class<K> keyClass, Class<? extends Serialization<? super K>> keySerialization, Class<V> valueClass, Class<? extends Serialization<? super V>> valueSerialization, long minBundleSize, KvCoder<K, V> coder) {
        super(fileMetadata, minBundleSize, startOffset, endOffset);
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.keySerializationClass = keySerialization;
        this.valueSerializationClass = valueSerialization;
        this.coder = coder;
    }

    protected FileBasedSource<KV<K, V>> createForSubrangeOfFile(MatchResult.Metadata fileMetadata, long start, long end) {
        LOG.debug((Object)("Creating source for subrange: " + start + "-" + end));
        return new SequenceFileSource<K, V>(fileMetadata, start, end, this.keyClass, this.keySerializationClass, this.valueClass, this.valueSerializationClass, this.getMinBundleSize(), this.coder);
    }

    protected FileBasedSource.FileBasedReader<KV<K, V>> createSingleFileReader(PipelineOptions options) {
        HashSet serializationNames = Sets.newHashSet((Object[])new String[]{this.keySerializationClass.getName(), this.valueSerializationClass.getName()});
        return new SeqFileReader<K, V>(this, this.keyClass, this.valueClass, serializationNames.toArray(new String[serializationNames.size()]));
    }

    public Coder<KV<K, V>> getDefaultOutputCoder() {
        return this.coder;
    }

    static class FileStream
    extends FSInputStream {
        private final SeekableByteChannel inner;
        private final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);

        FileStream(SeekableByteChannel inner) {
            this.inner = inner;
        }

        public void seek(long l) throws IOException {
            this.inner.position(l);
        }

        public long getPos() throws IOException {
            return this.inner.position();
        }

        public boolean seekToNewSource(long l) throws IOException {
            return false;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, offset, length);
            return this.inner.read(byteBuffer);
        }

        public int read() throws IOException {
            int numRead = 0;
            ((Buffer)this.singleByteBuffer).clear();
            while (numRead == 0) {
                numRead = this.inner.read(this.singleByteBuffer);
            }
            if (numRead == -1) {
                return -1;
            }
            return UnsignedBytes.toInt((byte)this.singleByteBuffer.get(0));
        }
    }

    static class SeqFileReader<K, V>
    extends FileBasedSource.FileBasedReader<KV<K, V>> {
        private final Class<K> keyClass;
        private final Class<V> valueClass;
        private final String[] serializationNames;
        private SequenceFile.Reader reader;
        private boolean isFirstRecord;
        private boolean isAtSplitPoint;
        private boolean eof;
        private long startOfNextRecord;
        private long startOfRecord;
        private KV<K, V> record;

        SeqFileReader(FileBasedSource<KV<K, V>> source, Class<K> keyClass, Class<V> valueClass, String[] serializationNames) {
            super(source);
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            this.serializationNames = serializationNames;
        }

        protected void startReading(ReadableByteChannel channel) throws IOException {
            Preconditions.checkState((boolean)(channel instanceof SeekableByteChannel), (String)"%s only supports reading from a SeekableByteChannel", (Object)SequenceFileSource.class.getSimpleName());
            SeekableByteChannel seekableByteChannel = (SeekableByteChannel)channel;
            FileStream fileStream = new FileStream(seekableByteChannel);
            FSDataInputStream fsDataInputStream = new FSDataInputStream((InputStream)((Object)fileStream));
            Configuration configuration = new Configuration(false);
            if (this.serializationNames.length > 0) {
                configuration.setStrings("io.serializations", this.serializationNames);
            }
            this.reader = new SequenceFile.Reader(configuration, new SequenceFile.Reader.Option[]{SequenceFile.Reader.stream((FSDataInputStream)fsDataInputStream)});
            try {
                this.reader.sync(this.getCurrentSource().getStartOffset());
            }
            catch (EOFException e) {
                LOG.debug((Object)("Found EOF when starting to read: " + this.getCurrentSource().getStartOffset()));
                this.eof = true;
            }
            this.startOfNextRecord = this.reader.getPosition();
            this.isFirstRecord = true;
            LOG.debug((Object)("startReading, offset: " + this.getCurrentSource().getStartOffset() + ", position: " + this.startOfNextRecord));
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
            super.close();
        }

        protected boolean readNextRecord() throws IOException {
            if (this.eof) {
                return false;
            }
            Object key = ReflectionUtils.newInstance(this.keyClass, null);
            Object value = ReflectionUtils.newInstance(this.valueClass, null);
            this.startOfRecord = this.startOfNextRecord;
            try {
                this.eof = this.reader.next(key) == null;
            }
            catch (EOFException e) {
                this.eof = true;
            }
            if (this.eof) {
                this.record = null;
            } else {
                value = this.readCurrentValueUnchecked(value);
                this.record = KV.of((Object)key, (Object)value);
            }
            this.isAtSplitPoint = this.isFirstRecord || this.reader.syncSeen();
            this.isFirstRecord = false;
            this.startOfNextRecord = this.reader.getPosition();
            return this.record != null;
        }

        private V readCurrentValueUnchecked(V value) throws IOException {
            return (V)this.reader.getCurrentValue(value);
        }

        protected boolean isAtSplitPoint() throws NoSuchElementException {
            return this.isAtSplitPoint;
        }

        protected long getCurrentOffset() throws NoSuchElementException {
            if (this.record == null) {
                throw new NoSuchElementException();
            }
            return this.startOfRecord;
        }

        public KV<K, V> getCurrent() throws NoSuchElementException {
            if (this.record == null) {
                throw new NoSuchElementException();
            }
            return this.record;
        }
    }
}

