/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.beam.CloudBigtableScanConfiguration;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import com.google.cloud.bigtable.beam.ScanValueProvider;
import com.google.cloud.bigtable.beam.sequencefiles.ExportJob;
import com.google.cloud.bigtable.beam.sequencefiles.ImportJob;
import com.google.cloud.bigtable.beam.validation.SyncTableJob;
import java.io.Serializable;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;

@InternalApi(value="For internal usage only")
public class TemplateUtils {
    public static CloudBigtableTableConfiguration buildImportConfig(ImportJob.ImportOptions opts, String customUserAgent) {
        CloudBigtableTableConfiguration.Builder builder = new CloudBigtableTableConfiguration.Builder().withProjectId(opts.getBigtableProject()).withInstanceId(opts.getBigtableInstanceId()).withTableId(opts.getBigtableTableId()).withConfiguration("google.bigtable.custom.user.agent", customUserAgent);
        if (opts.getBigtableAppProfileId() != null) {
            builder.withAppProfileId(opts.getBigtableAppProfileId());
        }
        ValueProvider.NestedValueProvider enableThrottling = ValueProvider.NestedValueProvider.of(opts.getMutationThrottleLatencyMs(), (SerializableFunction & Serializable)throttleMs -> String.valueOf(throttleMs > 0));
        builder.withConfiguration("google.bigtable.buffered.mutator.throttling.enable", (ValueProvider)enableThrottling);
        builder.withConfiguration("google.bigtable.buffered.mutator.throttling.threshold.ms", (ValueProvider)ValueProvider.NestedValueProvider.of(opts.getMutationThrottleLatencyMs(), String::valueOf));
        return builder.build();
    }

    public static CloudBigtableTableConfiguration buildSyncTableConfig(SyncTableJob.SyncTableOptions opts) {
        CloudBigtableTableConfiguration.Builder builder = new CloudBigtableTableConfiguration.Builder().withProjectId(opts.getBigtableProject()).withInstanceId(opts.getBigtableInstanceId()).withTableId(opts.getBigtableTableId()).withConfiguration("google.bigtable.custom.user.agent", "SyncTableJob");
        if (opts.getBigtableAppProfileId() != null) {
            builder.withAppProfileId(opts.getBigtableAppProfileId());
        }
        return builder.build();
    }

    public static CloudBigtableScanConfiguration buildExportConfig(ExportJob.ExportOptions options) {
        CloudBigtableScanConfiguration.Builder configBuilder = new CloudBigtableScanConfiguration.Builder().withProjectId(options.getBigtableProject()).withInstanceId(options.getBigtableInstanceId()).withTableId(options.getBigtableTableId()).withAppProfileId(options.getBigtableAppProfileId()).withConfiguration("google.bigtable.custom.user.agent", "SequenceFileExportJob").withConfiguration("google.cloud.bigtable.retry.idle.timeout", String.valueOf(options.getRetryIdleTimeout())).withScan((ValueProvider)new ScanValueProvider(options.getBigtableStartRow(), options.getBigtableStopRow(), options.getBigtableMaxVersions(), options.getBigtableFilter()));
        return configBuilder.build();
    }
}

