/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.hbasesnapshots;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;

class HBaseSnapshotInputConfigBuilder {
    private static final Log LOG = LogFactory.getLog(HBaseSnapshotInputConfigBuilder.class);
    private static final int BATCH_SIZE = 1000;
    public static final String RESTORE_DIR = "/.restore";
    private String projectId;
    private String hbaseSnapshotSourceDir;
    private String snapshotName;
    private String restoreDirSuffix;

    public HBaseSnapshotInputConfigBuilder setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public HBaseSnapshotInputConfigBuilder setHbaseSnapshotSourceDir(String hbaseSnapshotSourceDir) {
        this.hbaseSnapshotSourceDir = hbaseSnapshotSourceDir;
        return this;
    }

    public HBaseSnapshotInputConfigBuilder setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
        return this;
    }

    public HBaseSnapshotInputConfigBuilder setRestoreDirSuffix(String suffix) {
        this.restoreDirSuffix = suffix;
        return this;
    }

    public String getRestoreDir() {
        return RESTORE_DIR + this.restoreDirSuffix;
    }

    public Configuration build() throws Exception {
        Preconditions.checkState((this.projectId != null && !this.projectId.isEmpty() ? 1 : 0) != 0, (Object)"Required value projectId must be set");
        Preconditions.checkState((this.hbaseSnapshotSourceDir != null && !this.hbaseSnapshotSourceDir.isEmpty() ? 1 : 0) != 0, (Object)"Required value hbaseSnapshotSourceDir must be set");
        Preconditions.checkState((this.snapshotName != null && !this.snapshotName.isEmpty() ? 1 : 0) != 0, (Object)"Required value snapshotName must be set");
        Preconditions.checkState((boolean)this.hbaseSnapshotSourceDir.startsWith("gs"), (Object)"Snapshot folder must be hosted in a GCS bucket");
        Configuration conf = this.createHBaseConfiguration();
        conf.set("hbase.mapreduce.scan", TableMapReduceUtil.convertScanToString((Scan)new Scan().setBatch(1000)));
        Job job = Job.getInstance((Configuration)conf);
        TableSnapshotInputFormat.setInput((Job)job, (String)this.snapshotName, (Path)new Path(this.getRestoreDir()));
        return job.getConfiguration();
    }

    public Configuration createHBaseConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.rootdir", this.hbaseSnapshotSourceDir);
        conf.set("fs.defaultFS", this.hbaseSnapshotSourceDir);
        conf.set("fs.AbstractFileSystem.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS");
        conf.set("fs.gs.project.id", this.projectId);
        conf.setBoolean("google.cloud.auth.service.account.enable", true);
        conf.setClass("mapreduce.job.inputformat.class", TableSnapshotInputFormat.class, InputFormat.class);
        conf.setClass("key.class", ImmutableBytesWritable.class, Writable.class);
        conf.setClass("value.class", Result.class, Object.class);
        return conf;
    }
}

