/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;

class DataCellPredicateFactory
implements Function<Cell, Predicate<Cell>> {
    DataCellPredicateFactory() {
    }

    public Predicate<Cell> apply(Cell deleteMarker) {
        Preconditions.checkArgument((boolean)CellUtil.isDelete((Cell)deleteMarker), (Object)"expecting delete marker cell.");
        switch (KeyValue.Type.codeToType((byte)deleteMarker.getTypeByte())) {
            case Delete: {
                return Predicates.and((Predicate)new MatchQualifier(deleteMarker), (Predicate)new MatchExactTimestamp(deleteMarker));
            }
            case DeleteFamilyVersion: {
                return new MatchExactTimestamp(deleteMarker);
            }
            case DeleteColumn: {
                return Predicates.and((Predicate)new MatchQualifier(deleteMarker), (Predicate)new MatchTimestampRangeByUpperBound(deleteMarker));
            }
            case DeleteFamily: {
                return new MatchTimestampRangeByUpperBound(deleteMarker);
            }
        }
        throw new IllegalStateException("Unexpected type byte: " + deleteMarker.getTypeByte());
    }

    private static class MatchTimestampRangeByUpperBound
    implements Predicate<Cell> {
        private final Cell deleteMarker;

        MatchTimestampRangeByUpperBound(Cell deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        public boolean apply(Cell cell) {
            return CellComparator.getInstance().compareTimestamps(this.deleteMarker, cell) <= 0;
        }
    }

    private static class MatchExactTimestamp
    implements Predicate<Cell> {
        private final Cell deleteMarker;

        MatchExactTimestamp(Cell deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        public boolean apply(Cell cell) {
            return CellComparator.getInstance().compareTimestamps(this.deleteMarker, cell) == 0;
        }
    }

    private static class MatchQualifier
    implements Predicate<Cell> {
        private final Cell deleteMarker;

        MatchQualifier(Cell deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        public boolean apply(Cell cell) {
            return CellComparator.getInstance().compareQualifiers(this.deleteMarker, cell) == 0;
        }
    }
}

