/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.validation;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.bigtable.beam.validation.RangeHashCoder;
import com.google.cloud.bigtable.beam.validation.SyncTableUtils;
import com.google.cloud.bigtable.beam.validation.TableHashWrapper;
import com.google.cloud.bigtable.beam.validation.TableHashWrapperFactory;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

@InternalApi
public class HadoopHashTableSource
extends BoundedSource<RangeHash>
implements Serializable {
    private static final long serialVersionUID = 2383724L;
    private static final Coder<RangeHash> CODER = RangeHashCoder.of();
    public static final Log LOG = LogFactory.getLog(HadoopHashTableSource.class);
    private final ValueProvider<String> projectId;
    private final ValueProvider<String> sourceHashDir;
    @Nullable
    @VisibleForTesting
    transient ImmutableBytesWritable startRowInclusive;
    @Nullable
    @VisibleForTesting
    transient ImmutableBytesWritable stopRowExclusive;
    private final TableHashWrapperFactory tableHashWrapperFactory;

    public HadoopHashTableSource(ValueProvider<String> projectId, ValueProvider<String> sourceHashDir) {
        this(projectId, sourceHashDir, null, null);
    }

    @VisibleForTesting
    HadoopHashTableSource(ValueProvider<String> projectId, ValueProvider<String> sourceHashDir, @Nullable ImmutableBytesWritable startRowInclusive, @Nullable ImmutableBytesWritable stopRowExclusive) {
        this(projectId, sourceHashDir, startRowInclusive, stopRowExclusive, new TableHashWrapperFactory());
    }

    @VisibleForTesting
    HadoopHashTableSource(ValueProvider<String> projectId, ValueProvider<String> hadoopHashTableOutputDir, @Nullable ImmutableBytesWritable startRowInclusive, @Nullable ImmutableBytesWritable stopRowExclusive, TableHashWrapperFactory tableHashWrapperFactory) {
        this.projectId = projectId;
        this.sourceHashDir = hadoopHashTableOutputDir;
        this.startRowInclusive = startRowInclusive;
        this.stopRowExclusive = stopRowExclusive;
        this.tableHashWrapperFactory = tableHashWrapperFactory;
    }

    public List<? extends BoundedSource<RangeHash>> split(long desiredBundleSizeBytes, PipelineOptions options) throws IOException {
        TableHashWrapper hash = this.tableHashWrapperFactory.getTableHash((String)this.projectId.get(), (String)this.sourceHashDir.get());
        ImmutableList<ImmutableBytesWritable> partitions = hash.getPartitions();
        int numPartitions = partitions.size();
        ArrayList<HadoopHashTableSource> splitSources = new ArrayList<HadoopHashTableSource>(numPartitions + 1);
        if (numPartitions == 0) {
            splitSources.add(new HadoopHashTableSource(this.projectId, this.sourceHashDir, hash.getStartRow(), hash.getStopRow(), this.tableHashWrapperFactory));
            return splitSources;
        }
        ImmutableBytesWritable nextStartRow = hash.getStartRow();
        ImmutableBytesWritable stopRow = hash.getStopRow();
        for (int i = 0; i < numPartitions; ++i) {
            LOG.debug((Object)("Adding: [" + SyncTableUtils.immutableBytesToString(nextStartRow.get()) + ", " + SyncTableUtils.immutableBytesToString(((ImmutableBytesWritable)partitions.get(i)).get()) + ")"));
            splitSources.add(new HadoopHashTableSource(this.projectId, this.sourceHashDir, nextStartRow, (ImmutableBytesWritable)partitions.get(i), this.tableHashWrapperFactory));
            nextStartRow = (ImmutableBytesWritable)partitions.get(i);
        }
        LOG.debug((Object)("Adding: [" + SyncTableUtils.immutableBytesToString(nextStartRow.get()) + ", " + SyncTableUtils.immutableBytesToString(stopRow.get()) + ")"));
        splitSources.add(new HadoopHashTableSource(this.projectId, this.sourceHashDir, nextStartRow, stopRow, this.tableHashWrapperFactory));
        LOG.info((Object)("Returning " + splitSources.size() + " sources from " + numPartitions + " partitions"));
        return splitSources;
    }

    public Coder<RangeHash> getOutputCoder() {
        return CODER;
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return 0L;
    }

    public BoundedSource.BoundedReader<RangeHash> createReader(PipelineOptions options) throws IOException {
        TableHashWrapper hash = this.tableHashWrapperFactory.getTableHash((String)this.projectId.get(), (String)this.sourceHashDir.get());
        if (this.startRowInclusive == null || this.stopRowExclusive == null) {
            this.startRowInclusive = hash.getStartRow();
            this.stopRowExclusive = hash.getStopRow();
        }
        return new HashBasedReader(this, this.startRowInclusive, this.stopRowExclusive, hash.newReader(SyncTableUtils.createConfiguration((String)this.projectId.get(), (String)this.sourceHashDir.get()), this.startRowInclusive));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HadoopHashTableSource)) {
            return false;
        }
        HadoopHashTableSource that = (HadoopHashTableSource)o;
        return Objects.equal(this.projectId, that.projectId) && Objects.equal(this.sourceHashDir, that.sourceHashDir) && Objects.equal((Object)this.startRowInclusive, (Object)that.startRowInclusive) && Objects.equal((Object)this.stopRowExclusive, (Object)that.stopRowExclusive);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectId, this.sourceHashDir, this.startRowInclusive, this.stopRowExclusive});
    }

    public String toString() {
        return "HadoopHashTableSource [" + SyncTableUtils.immutableBytesToString(this.startRowInclusive) + ", " + SyncTableUtils.immutableBytesToString(this.stopRowExclusive) + ')';
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.startRowInclusive == null) {
            s.writeBoolean(false);
        } else {
            s.writeBoolean(true);
            s.writeObject(this.startRowInclusive.copyBytes());
        }
        if (this.stopRowExclusive == null) {
            s.writeBoolean(false);
        } else {
            s.writeBoolean(true);
            s.writeObject(this.stopRowExclusive.copyBytes());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (s.readBoolean()) {
            this.startRowInclusive = new ImmutableBytesWritable((byte[])s.readObject());
        }
        if (s.readBoolean()) {
            this.stopRowExclusive = new ImmutableBytesWritable((byte[])s.readObject());
        }
    }

    @VisibleForTesting
    static class HashBasedReader
    extends BoundedSource.BoundedReader<RangeHash> {
        private final HadoopHashTableSource source;
        private final TableHashWrapper.TableHashReader reader;
        @VisibleForTesting
        final ImmutableBytesWritable startRowInclusive;
        @VisibleForTesting
        final ImmutableBytesWritable stopRowExclusive;
        private boolean isDone = false;
        private ImmutableBytesWritable currentRangeStartKey;
        private ImmutableBytesWritable currentHash;
        private RangeHash currentRangeHash;

        public HashBasedReader(HadoopHashTableSource source, ImmutableBytesWritable startRowInclusive, ImmutableBytesWritable stopRowExclusive, TableHashWrapper.TableHashReader reader) {
            this.source = source;
            this.startRowInclusive = startRowInclusive;
            this.stopRowExclusive = stopRowExclusive;
            this.reader = reader;
        }

        public boolean start() throws IOException {
            LOG.debug((Object)("Starting a new reader at key range [" + SyncTableUtils.immutableBytesToString(this.startRowInclusive) + " ," + SyncTableUtils.immutableBytesToString(this.stopRowExclusive) + ")."));
            if (this.readNextKey()) {
                this.advance();
                return true;
            }
            this.isDone = true;
            return false;
        }

        public boolean advance() throws IOException {
            if (this.isDone) {
                LOG.debug((Object)("Ending workitem at key " + SyncTableUtils.immutableBytesToString(this.currentRangeStartKey) + " ."));
                return false;
            }
            ImmutableBytesWritable startKey = this.currentRangeStartKey;
            ImmutableBytesWritable hash = this.currentHash;
            this.isDone = !this.readNextKey();
            this.currentRangeHash = RangeHash.of(startKey, this.currentRangeStartKey, hash);
            return true;
        }

        private boolean readNextKey() throws IOException {
            if (this.reader.next()) {
                this.currentRangeStartKey = this.reader.getCurrentKey();
                if (this.stopRowExclusive.equals((Object)HConstants.EMPTY_END_ROW) || this.currentRangeStartKey.compareTo(this.stopRowExclusive) < 0) {
                    this.currentHash = this.reader.getCurrentHash();
                    return true;
                }
                this.currentHash = null;
                return false;
            }
            this.currentRangeStartKey = this.stopRowExclusive;
            this.currentHash = null;
            return false;
        }

        public RangeHash getCurrent() {
            return this.currentRangeHash;
        }

        public void close() throws IOException {
            LOG.info((Object)("Finishing a reader for key range [" + SyncTableUtils.immutableBytesToString(this.startRowInclusive) + " ," + SyncTableUtils.immutableBytesToString(this.stopRowExclusive) + "). Ending at " + SyncTableUtils.immutableBytesToString(this.currentRangeStartKey)));
            this.reader.close();
        }

        public BoundedSource<RangeHash> getCurrentSource() {
            return this.source;
        }
    }

    @DefaultCoder(value=RangeHashCoder.class)
    public static class RangeHash {
        public final ImmutableBytesWritable startInclusive;
        public final ImmutableBytesWritable stopExclusive;
        public final ImmutableBytesWritable hash;

        private RangeHash(ImmutableBytesWritable startInclusive, ImmutableBytesWritable stopExclusive, ImmutableBytesWritable hash) {
            this.startInclusive = startInclusive;
            this.stopExclusive = stopExclusive;
            this.hash = hash;
        }

        static RangeHash of(ImmutableBytesWritable startInclusive, ImmutableBytesWritable stopExclusive, ImmutableBytesWritable hash) {
            Preconditions.checkNotNull((Object)startInclusive);
            Preconditions.checkNotNull((Object)stopExclusive);
            Preconditions.checkNotNull((Object)hash);
            return new RangeHash(startInclusive, stopExclusive, hash);
        }

        public String toString() {
            return String.format("RangeHash{ range = [ %s, %s), hash: %s }", SyncTableUtils.immutableBytesToString(this.startInclusive), SyncTableUtils.immutableBytesToString(this.stopExclusive), SyncTableUtils.immutableBytesToString(this.hash));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RangeHash)) {
                return false;
            }
            RangeHash rangeHash = (RangeHash)o;
            return Objects.equal((Object)this.startInclusive, (Object)rangeHash.startInclusive) && Objects.equal((Object)this.stopExclusive, (Object)rangeHash.stopExclusive) && Objects.equal((Object)this.hash, (Object)rangeHash.hash);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.startInclusive, this.stopExclusive, this.hash});
        }
    }
}

