/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.validation;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.gson.Gson;
import com.google.cloud.bigtable.beam.sequencefiles.Utils;
import com.google.cloud.bigtable.beam.validation.BufferedHadoopHashTableSource;
import com.google.cloud.bigtable.beam.validation.ComputeAndValidateHashFromBigtableDoFn;
import com.google.cloud.bigtable.beam.validation.HadoopHashTableSource;
import com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@InternalExtensionOnly
public class SyncTableJob {
    private static final Log LOG = LogFactory.getLog(SyncTableJob.class);

    public static void main(String[] args) {
        PipelineOptionsFactory.register(SyncTableOptions.class);
        SyncTableOptions opts = (SyncTableOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(SyncTableOptions.class);
        LOG.info((Object)"===> Building Pipeline");
        Pipeline pipeline = SyncTableJob.buildPipeline(opts);
        LOG.info((Object)"===> Running Pipeline");
        PipelineResult result = pipeline.run();
        if (opts.getWait()) {
            Utils.waitForPipelineToFinish(result);
        }
        MetricQueryResults metrics = result.metrics().allMetrics();
        for (MetricResult counter : metrics.getCounters()) {
            LOG.warn((Object)(counter.getName() + ":" + counter.getAttempted()));
        }
    }

    @VisibleForTesting
    public static Pipeline buildPipeline(SyncTableOptions opts) {
        Pipeline pipeline = Pipeline.create((PipelineOptions)Utils.tweakOptions((PipelineOptions)opts));
        ((PCollection)((PCollection)((PCollection)((PCollection)pipeline.apply("Read HBase HashTable output", (PTransform)Read.from((BoundedSource)new BufferedHadoopHashTableSource(new HadoopHashTableSource(opts.getBigtableProject(), opts.getHashTableOutputDir()))))).apply("group by and create granular workitems", (PTransform)GroupByKey.create())).apply("validate hash", (PTransform)ParDo.of((DoFn)new ComputeAndValidateHashFromBigtableDoFn(opts)))).apply("Serialize the ranges", (PTransform)MapElements.via((SimpleFunction)new RangeHashToString()))).apply("Write to file", (PTransform)TextIO.write().to(opts.getOutputPrefix()).withSuffix(".txt"));
        return pipeline;
    }

    static class RangeHashToString
    extends SimpleFunction<HadoopHashTableSource.RangeHash, String> {
        private static final Gson GSON = new Gson();

        RangeHashToString() {
        }

        public String apply(HadoopHashTableSource.RangeHash input) {
            return GSON.toJson((Object)input);
        }
    }

    public static interface SyncTableOptions
    extends GcpOptions {
        @Description(value="This Bigtable App Profile id.")
        public ValueProvider<String> getBigtableAppProfileId();

        public void setBigtableAppProfileId(ValueProvider<String> var1);

        @Description(value="The project that contains the table to export. Defaults to --project.")
        @Default.InstanceFactory(value=Utils.DefaultBigtableProjectFactory.class)
        public ValueProvider<String> getBigtableProject();

        public void setBigtableProject(ValueProvider<String> var1);

        @Description(value="The Bigtable instance id that contains the table to export.")
        public ValueProvider<String> getBigtableInstanceId();

        public void setBigtableInstanceId(ValueProvider<String> var1);

        @Description(value="The Bigtable table id to export.")
        public ValueProvider<String> getBigtableTableId();

        public void setBigtableTableId(ValueProvider<String> var1);

        @Description(value="HBase HashTable job output dir.")
        public ValueProvider<String> getHashTableOutputDir();

        public void setHashTableOutputDir(ValueProvider<String> var1);

        @Description(value="File pattern for files containing mismatched row ranges.")
        public ValueProvider<String> getOutputPrefix();

        public void setOutputPrefix(ValueProvider<String> var1);

        @Description(value="Wait for pipeline to finish.")
        @Default.Boolean(value=true)
        public boolean getWait();

        public void setWait(boolean var1);
    }
}

