/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.validation;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi
public class SyncTableUtils {
    private SyncTableUtils() {
    }

    public static String immutableBytesToString(ImmutableBytesWritable bytes) {
        if (bytes == null) {
            return "";
        }
        return SyncTableUtils.immutableBytesToString(bytes.get());
    }

    public static String immutableBytesToString(byte[] bytes) {
        return Bytes.toStringBinary((byte[])bytes);
    }

    public static Configuration createConfiguration(String projectId, String sourceHashDir) {
        Configuration conf = HBaseConfiguration.create();
        conf.set("fs.AbstractFileSystem.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS");
        conf.set("fs.gs.project.id", projectId);
        conf.set("fs.defaultFS", sourceHashDir);
        conf.set("google.cloud.auth.service.account.enable", "true");
        return conf;
    }
}

