/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.validation;

import com.google.cloud.bigtable.beam.validation.SyncTableUtils;
import com.google.cloud.bigtable.beam.validation.TableHashWrapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.BigtableTableHashAccessor;
import org.apache.hadoop.hbase.mapreduce.HashTable;

class TableHashWrapperImpl
implements TableHashWrapper {
    private final HashTable.TableHash hash;

    static TableHashWrapper create(Configuration conf, String hashTableOutputDir) throws IOException {
        HashTable.TableHash tableHash = HashTable.TableHash.read((Configuration)conf, (Path)new Path(hashTableOutputDir));
        TableHashWrapperImpl tableHashWrapper = new TableHashWrapperImpl(tableHash);
        Preconditions.checkArgument((tableHashWrapper.getNumHashFiles() == tableHashWrapper.getPartitions().size() + 1 ? 1 : 0) != 0, (String)"Corrupt hashtable output. %d hash files for %d partitions. Expected %d files.", (Object)tableHashWrapper.getNumHashFiles(), (Object)tableHashWrapper.getPartitions().size(), (Object)(tableHashWrapper.getPartitions().size() + 1));
        return tableHashWrapper;
    }

    private TableHashWrapperImpl(HashTable.TableHash hash) {
        this.hash = hash;
    }

    @Override
    public int getNumHashFiles() {
        return BigtableTableHashAccessor.getNumHashFiles(this.hash);
    }

    @Override
    public ImmutableList<ImmutableBytesWritable> getPartitions() {
        return BigtableTableHashAccessor.getPartitions(this.hash);
    }

    @Override
    public ImmutableBytesWritable getStartRow() {
        return BigtableTableHashAccessor.getStartRow(this.hash);
    }

    @Override
    public ImmutableBytesWritable getStopRow() {
        return BigtableTableHashAccessor.getStopRow(this.hash);
    }

    @Override
    public Scan getScan() {
        try {
            return BigtableTableHashAccessor.getScan(this.hash);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init a scan from TableHash: ", e);
        }
    }

    @Override
    public TableHashWrapper.TableHashReader newReader(Configuration conf, ImmutableBytesWritable startRow) {
        try {
            return TableHashReaderImpl.create(this.hash.newReader(conf, startRow));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open reader at " + SyncTableUtils.immutableBytesToString(startRow.copyBytes()), e);
        }
    }

    static class TableHashReaderImpl
    implements TableHashWrapper.TableHashReader {
        private final HashTable.TableHash.Reader reader;

        static TableHashReaderImpl create(HashTable.TableHash.Reader reader) {
            Preconditions.checkNotNull((Object)reader, (Object)"Reader can not be null.");
            return new TableHashReaderImpl(reader);
        }

        private TableHashReaderImpl(HashTable.TableHash.Reader reader) {
            this.reader = reader;
        }

        @Override
        public boolean next() throws IOException {
            return this.reader.next();
        }

        @Override
        public ImmutableBytesWritable getCurrentKey() {
            return this.reader.getCurrentKey();
        }

        @Override
        public ImmutableBytesWritable getCurrentHash() {
            return this.reader.getCurrentHash();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

