/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HashTable;

@InternalApi
public class BigtableTableHashAccessor {
    private BigtableTableHashAccessor() {
    }

    public static int getNumHashFiles(HashTable.TableHash hash) {
        return hash.numHashFiles;
    }

    public static ImmutableList<ImmutableBytesWritable> getPartitions(HashTable.TableHash hash) {
        return ImmutableList.copyOf((Collection)hash.partitions);
    }

    public static ImmutableBytesWritable getStartRow(HashTable.TableHash hash) {
        return new ImmutableBytesWritable(hash.startRow);
    }

    public static ImmutableBytesWritable getStopRow(HashTable.TableHash hash) {
        return new ImmutableBytesWritable(hash.stopRow);
    }

    public static Scan getScan(HashTable.TableHash hash) throws IOException {
        return hash.initScan();
    }

    public static class BigtableResultHasher {
        private final HashTable.ResultHasher hasher = new HashTable.ResultHasher();

        public void startBatch(ImmutableBytesWritable batchStartKey) {
            this.hasher.startBatch(batchStartKey);
        }

        public void finishBatch() {
            this.hasher.finishBatch();
        }

        public ImmutableBytesWritable getBatchHash() {
            return this.hasher.getBatchHash();
        }

        public void hashResult(Result result) {
            this.hasher.hashResult(result);
        }
    }
}

