/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.beam.hbasesnapshots.ImportJobFromHbaseSnapshot;
import com.google.cloud.bigtable.beam.sequencefiles.CreateTableHelper;
import com.google.cloud.bigtable.beam.sequencefiles.ExportJob;
import com.google.cloud.bigtable.beam.sequencefiles.ImportJob;
import com.google.cloud.bigtable.beam.validation.SyncTableJob;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;

@InternalExtensionOnly
public final class Main {
    @InternalApi(value="For internal usage only")
    public Main() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Main.usage();
            System.exit(1);
        }
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (args[0]) {
            case "export": {
                ExportJob.main(subArgs);
                break;
            }
            case "import": {
                ImportJob.main(subArgs);
                break;
            }
            case "importsnapshot": {
                ImportJobFromHbaseSnapshot.main(subArgs);
                break;
            }
            case "create-table": {
                CreateTableHelper.main(subArgs);
                break;
            }
            case "sync-table": {
                SyncTableJob.main(subArgs);
                break;
            }
            default: {
                Main.usage();
                System.exit(1);
            }
        }
    }

    private static void usage() {
        String jarName;
        try {
            jarName = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getName();
        }
        catch (URISyntaxException e) {
            jarName = "<jar>";
        }
        System.out.printf("java -jar %s <action> <action_params>\nWhere <action> can be 'export', 'import' , 'importsnapshot' or 'create-table'. To get further help, run: \njava -jar %s <action> --help\n", jarName, jarName);
    }
}

