/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.hbasesnapshots;

import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CleanupHBaseSnapshotRestoreFilesFn
extends DoFn<KV<String, String>, Boolean> {
    private static final Log LOG = LogFactory.getLog(CleanupHBaseSnapshotRestoreFilesFn.class);

    CleanupHBaseSnapshotRestoreFilesFn() {
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) throws IOException {
        Objects objects;
        KV elem = (KV)context.element();
        String hbaseSnapshotDir = (String)elem.getKey();
        String restorePath = (String)elem.getValue();
        String prefix = CleanupHBaseSnapshotRestoreFilesFn.getListPrefix(restorePath);
        String bucketName = CleanupHBaseSnapshotRestoreFilesFn.getWorkingBucketName(hbaseSnapshotDir);
        Preconditions.checkState((!prefix.isEmpty() && !hbaseSnapshotDir.contains(String.format("%s/%s", bucketName, prefix)) ? 1 : 0) != 0, (Object)"restore folder should not be empty or a subfolder of hbaseSnapshotSourceDir");
        GcpOptions gcpOptions = (GcpOptions)context.getPipelineOptions().as(GcpOptions.class);
        GcsUtil gcsUtil = new GcsUtil.GcsUtilFactory().create((PipelineOptions)gcpOptions);
        String pageToken = null;
        ArrayList results = new ArrayList();
        while ((objects = gcsUtil.listObjects(bucketName, prefix, pageToken)).getItems() != null) {
            objects.getItems().stream().map(storageObject -> GcsPath.fromObject((StorageObject)storageObject).toString()).forEach(results::add);
            pageToken = objects.getNextPageToken();
            if (pageToken != null) continue;
        }
        gcsUtil.remove(results);
        context.output((Object)true);
    }

    public static String getWorkingBucketName(String hbaseSnapshotDir) {
        Preconditions.checkArgument((boolean)hbaseSnapshotDir.startsWith("gs"), (Object)"snapshot folder must be hosted in a GCS bucket ");
        return GcsPath.fromUri((String)hbaseSnapshotDir).getBucket();
    }

    public static String getListPrefix(String restorePath) {
        Preconditions.checkArgument((boolean)restorePath.startsWith("/"), (Object)"restore folder must be an absolute path in current filesystem");
        return restorePath.substring(1);
    }
}

