/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.hbasesnapshots;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.beam.CloudBigtableIO;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import com.google.cloud.bigtable.beam.TemplateUtils;
import com.google.cloud.bigtable.beam.hbasesnapshots.CleanupHBaseSnapshotRestoreFilesFn;
import com.google.cloud.bigtable.beam.hbasesnapshots.HBaseSnapshotInputConfigBuilder;
import com.google.cloud.bigtable.beam.sequencefiles.HBaseResultToMutationFn;
import com.google.cloud.bigtable.beam.sequencefiles.ImportJob;
import com.google.cloud.bigtable.beam.sequencefiles.Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.hadoop.format.HadoopFormatIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@InternalExtensionOnly
public class ImportJobFromHbaseSnapshot {
    private static final Log LOG = LogFactory.getLog(ImportJobFromHbaseSnapshot.class);
    private static final String CONTAINER_IMAGE_PATH_PREFIX = "gcr.io/cloud-bigtable-ecosystem/unified-harness:";

    public static void main(String[] args) throws Exception {
        PipelineOptionsFactory.register(ImportOptions.class);
        ImportOptions opts = (ImportOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(ImportOptions.class);
        LOG.info((Object)"Building Pipeline");
        Pipeline pipeline = ImportJobFromHbaseSnapshot.buildPipeline(opts);
        LOG.info((Object)"Running Pipeline");
        PipelineResult result = pipeline.run();
        if (opts.getWait()) {
            Utils.waitForPipelineToFinish(result);
        }
    }

    @VisibleForTesting
    static Pipeline buildPipeline(ImportOptions opts) throws Exception {
        if (opts.getEnableSnappy().booleanValue()) {
            DataflowPipelineOptions dataFlowOpts = (DataflowPipelineOptions)opts.as(DataflowPipelineOptions.class);
            dataFlowOpts.setSdkContainerImage(CONTAINER_IMAGE_PATH_PREFIX + ReleaseInfo.getReleaseInfo().getVersion());
            ArrayList<String> expOpts = (ArrayList<String>)MoreObjects.firstNonNull((Object)dataFlowOpts.getExperiments(), new ArrayList());
            if (!expOpts.contains("use_runner_v2")) {
                expOpts = new ArrayList<String>(expOpts);
                expOpts.add("use_runner_v2");
            }
            dataFlowOpts.setExperiments((List)expOpts);
        }
        Pipeline pipeline = Pipeline.create((PipelineOptions)Utils.tweakOptions((PipelineOptions)opts));
        HBaseSnapshotInputConfigBuilder configurationBuilder = new HBaseSnapshotInputConfigBuilder().setProjectId(opts.getProject()).setHbaseSnapshotSourceDir(opts.getHbaseSnapshotSourceDir()).setSnapshotName(opts.getSnapshotName()).setRestoreDirSuffix(opts.getJobName());
        PCollection readResult = (PCollection)pipeline.apply("Read from HBase Snapshot", (PTransform)HadoopFormatIO.read().withConfiguration(configurationBuilder.build()));
        ((PCollection)readResult.apply("Create Mutations", (PTransform)ParDo.of((DoFn)new HBaseResultToMutationFn()))).apply("Write to Bigtable", CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)TemplateUtils.buildImportConfig(opts, "HBaseSnapshotImportJob")));
        List<KV> sourceAndRestoreFolders = Arrays.asList(KV.of((Object)opts.getHbaseSnapshotSourceDir(), (Object)configurationBuilder.getRestoreDir()));
        ((PCollection)((PCollection)pipeline.apply((PTransform)Create.of(sourceAndRestoreFolders))).apply((PTransform)Wait.on((PCollection[])new PCollection[]{readResult}))).apply((PTransform)ParDo.of((DoFn)new CleanupHBaseSnapshotRestoreFilesFn()));
        return pipeline;
    }

    public static interface ImportOptions
    extends ImportJob.ImportOptions {
        @Description(value="The HBase root dir where HBase snapshot files resides.")
        public String getHbaseSnapshotSourceDir();

        public void setHbaseSnapshotSourceDir(String var1);

        @Description(value="Snapshot name")
        public String getSnapshotName();

        public void setSnapshotName(String var1);

        @Description(value="Is importing Snappy compressed snapshot.")
        @Default.Boolean(value=false)
        public Boolean getEnableSnappy();

        public void setEnableSnappy(Boolean var1);
    }
}

