/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.beam.sequencefiles.ImportJob;
import com.google.cloud.bigtable.beam.sequencefiles.SequenceFileSource;
import com.google.cloud.bigtable.beam.sequencefiles.Utils;
import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.values.KV;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

@InternalApi
public class CreateTableHelper {
    private static final Log LOG = LogFactory.getLog(CreateTableHelper.class);

    public static void main(String[] args) throws Exception {
        PipelineOptionsFactory.register(CreateTableOpts.class);
        CreateTableOpts opts = (CreateTableOpts)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(CreateTableOpts.class);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)opts);
        CreateTableHelper.createTable(opts);
    }

    static void createTable(CreateTableOpts opts) throws Exception {
        LOG.info((Object)"Extracting splits from the source files");
        SequenceFileSource<ImmutableBytesWritable, Result> source = ImportJob.createSource((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)opts.getSourcePattern()));
        List splitSources = source.split(0x6400000L, (PipelineOptions)opts);
        ForkJoinPool forkJoinPool = new ForkJoinPool(opts.getSplitConcurrency());
        byte[][] splits = (byte[][])((ForkJoinTask)forkJoinPool.submit(() -> (byte[][])((Stream)splitSources.stream().parallel()).map(splitSource -> {
            try (BoundedSource.BoundedReader reader = splitSource.createReader((PipelineOptions)opts);){
                if (!reader.start()) return null;
                ImmutableBytesWritable immutableBytesWritable = (ImmutableBytesWritable)((KV)reader.getCurrent()).getKey();
                return immutableBytesWritable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).sorted().map(ImmutableBytesWritable::copyBytes).toArray(x$0 -> new byte[x$0][]))).get();
        LOG.info((Object)String.format("Creating a new table with %d splits and the families: %s", splits.length, opts.getFamilies()));
        try (Connection connection = BigtableConfiguration.connect((String)opts.getBigtableProject(), (String)opts.getBigtableInstanceId());){
            TableName tableName = TableName.valueOf((String)opts.getBigtableTableId());
            HTableDescriptor descriptor = new HTableDescriptor(tableName);
            for (String family : opts.getFamilies()) {
                descriptor.addFamily(new HColumnDescriptor(family));
            }
            connection.getAdmin().createTable(descriptor, splits);
        }
    }

    @InternalApi
    public static interface CreateTableOpts
    extends GcpOptions {
        @Description(value="The project that contains the table to export. Defaults to --project.")
        @Default.InstanceFactory(value=Utils.DefaultBigtableProjectFactory.class)
        @Validation.Required
        public String getBigtableProject();

        public void setBigtableProject(String var1);

        @Description(value="The Bigtable instance id that contains the table to export.")
        @Validation.Required
        public String getBigtableInstanceId();

        public void setBigtableInstanceId(String var1);

        @Description(value="The Bigtable table id to export.")
        @Validation.Required
        public String getBigtableTableId();

        public void setBigtableTableId(String var1);

        @Description(value="The fully qualified file pattern to import. Should of the form '[destinationPath]/part-*'")
        @Validation.Required
        public String getSourcePattern();

        public void setSourcePattern(String var1);

        @Description(value="The families to add to the new table")
        @Validation.Required
        public List<String> getFamilies();

        public void setFamilies(List<String> var1);

        @Description(value="Number of threads to use when probing files for splits")
        @Default.Integer(value=100)
        public int getSplitConcurrency();

        public void setSplitConcurrency(int var1);
    }
}

