/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.beam.CloudBigtableIO;
import com.google.cloud.bigtable.beam.CloudBigtableScanConfiguration;
import com.google.cloud.bigtable.beam.TemplateUtils;
import com.google.cloud.bigtable.beam.sequencefiles.SequenceFileSink;
import com.google.cloud.bigtable.beam.sequencefiles.Utils;
import com.google.cloud.bigtable.thirdparty.org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.serializer.WritableSerialization;

@InternalExtensionOnly
public class ExportJob {
    public static void main(String[] args) {
        PipelineOptionsFactory.register(ExportOptions.class);
        ExportOptions opts = (ExportOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(ExportOptions.class);
        Pipeline pipeline = ExportJob.buildPipeline(opts);
        PipelineResult result = pipeline.run();
        if (opts.getWait()) {
            Utils.waitForPipelineToFinish(result);
        }
    }

    static Pipeline buildPipeline(ExportOptions opts) {
        ValueProvider.NestedValueProvider destinationPath = ValueProvider.NestedValueProvider.of(opts.getDestinationPath(), (SerializableFunction)new StringToDirResourceId());
        FilePathPrefix filePathPrefix = new FilePathPrefix((ValueProvider<ResourceId>)destinationPath, opts.getFilenamePrefix());
        SequenceFileSink<ImmutableBytesWritable, Result> sink = new SequenceFileSink<ImmutableBytesWritable, Result>((ValueProvider<ResourceId>)destinationPath, (FileBasedSink.FilenamePolicy)DefaultFilenamePolicy.fromStandardParameters((ValueProvider)filePathPrefix, null, (String)"", (boolean)false), ImmutableBytesWritable.class, WritableSerialization.class, Result.class, ResultSerialization.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)Utils.tweakOptions((PipelineOptions)opts));
        CloudBigtableScanConfiguration config = TemplateUtils.buildExportConfig(opts);
        ((PCollection)((PCollection)pipeline.apply("Read table", (PTransform)Read.from((BoundedSource)CloudBigtableIO.read((CloudBigtableScanConfiguration)config)))).apply("Format results", (PTransform)MapElements.via((SimpleFunction)new ResultToKV()))).apply("Write", (PTransform)WriteFiles.to(sink));
        return pipeline;
    }

    static class FilePathPrefix
    implements ValueProvider<ResourceId>,
    Serializable {
        private final ValueProvider<ResourceId> destinationPath;
        private final ValueProvider<String> filenamePrefix;

        FilePathPrefix(ValueProvider<ResourceId> destinationPath, ValueProvider<String> filenamePrefix) {
            this.destinationPath = destinationPath;
            this.filenamePrefix = filenamePrefix;
        }

        public ResourceId get() {
            return ((ResourceId)this.destinationPath.get()).resolve((String)this.filenamePrefix.get(), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        public boolean isAccessible() {
            return this.destinationPath.isAccessible() && this.filenamePrefix.isAccessible();
        }
    }

    static class StringToDirResourceId
    implements SerializableFunction<String, ResourceId>,
    Serializable {
        StringToDirResourceId() {
        }

        public ResourceId apply(String input) {
            return FileSystems.matchNewResource((String)input, (boolean)true);
        }
    }

    static class ResultToKV
    extends SimpleFunction<Result, KV<ImmutableBytesWritable, Result>> {
        ResultToKV() {
        }

        public KV<ImmutableBytesWritable, Result> apply(Result input) {
            return KV.of((Object)new ImmutableBytesWritable(input.getRow()), (Object)input);
        }
    }

    public static interface ExportOptions
    extends GcpOptions {
        @Description(value="This Bigtable App Profile id.")
        public ValueProvider<String> getBigtableAppProfileId();

        public void setBigtableAppProfileId(ValueProvider<String> var1);

        @Description(value="The project that contains the table to export. Defaults to --project.")
        @Default.InstanceFactory(value=Utils.DefaultBigtableProjectFactory.class)
        public ValueProvider<String> getBigtableProject();

        public void setBigtableProject(ValueProvider<String> var1);

        @Description(value="The Bigtable instance id that contains the table to export.")
        public ValueProvider<String> getBigtableInstanceId();

        public void setBigtableInstanceId(ValueProvider<String> var1);

        @Description(value="The Bigtable table id to export.")
        public ValueProvider<String> getBigtableTableId();

        public void setBigtableTableId(ValueProvider<String> var1);

        @Description(value="The row where to start the export from, defaults to the first row.")
        @Default.String(value="")
        public ValueProvider<String> getBigtableStartRow();

        public void setBigtableStartRow(ValueProvider<String> var1);

        @Description(value="The row where to stop the export, defaults to last row.")
        @Default.String(value="")
        public ValueProvider<String> getBigtableStopRow();

        public void setBigtableStopRow(ValueProvider<String> var1);

        @Description(value="Maximum number of cell versions.")
        @Default.Integer(value=0x7FFFFFFF)
        public ValueProvider<Integer> getBigtableMaxVersions();

        public void setBigtableMaxVersions(ValueProvider<Integer> var1);

        @Description(value="Filter string. See: http://hbase.apache.org/book.html#thrift.")
        @Default.String(value="")
        public ValueProvider<String> getBigtableFilter();

        public void setBigtableFilter(ValueProvider<String> var1);

        @Description(value="The destination directory")
        public ValueProvider<String> getDestinationPath();

        public void setDestinationPath(ValueProvider<String> var1);

        @Description(value="The prefix for each shard in destinationPath")
        @Default.String(value="part")
        public ValueProvider<String> getFilenamePrefix();

        public void setFilenamePrefix(ValueProvider<String> var1);

        @Description(value="Wait for pipeline to finish.")
        @Default.Boolean(value=true)
        public boolean getWait();

        public void setWait(boolean var1);
    }
}

