/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

class HadoopSerializationCoder<T>
extends CustomCoder<T> {
    private final Class<T> type;
    private final Class<? extends Serialization<T>> serializationClass;
    private transient Serialization<T> serialization;

    HadoopSerializationCoder(Class<T> type, Class<? extends Serialization<? super T>> serializationClass) {
        this.type = type;
        this.serializationClass = serializationClass;
        try {
            this.serialization = serializationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate the serialization class");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.serialization = this.serializationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to deserialize " + HadoopSerializationCoder.class.getSimpleName());
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(T value, OutputStream outStream) throws CoderException, IOException {
        serializer.open((OutputStream)new UncloseableOutputStream(outStream));
        try (Serializer serializer = this.serialization.getSerializer(this.type);){
            serializer.serialize(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T decode(InputStream inStream) throws CoderException, IOException {
        deserializer.open((InputStream)new UncloseableInputStream(inStream));
        try (Deserializer deserializer = this.serialization.getDeserializer(this.type);){
            Object object = deserializer.deserialize(null);
            return (T)object;
        }
    }

    private static class UncloseableInputStream
    extends FilterInputStream {
        public UncloseableInputStream(InputStream delegate) {
            super(delegate);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class UncloseableOutputStream
    extends FilterOutputStream {
        public UncloseableOutputStream(OutputStream delegate) {
            super(delegate);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

