/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.beam.CloudBigtableIO;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import com.google.cloud.bigtable.beam.TemplateUtils;
import com.google.cloud.bigtable.beam.sequencefiles.HBaseResultToMutationFn;
import com.google.cloud.bigtable.beam.sequencefiles.SequenceFileSource;
import com.google.cloud.bigtable.beam.sequencefiles.ShuffledSource;
import com.google.cloud.bigtable.beam.sequencefiles.Utils;
import com.google.cloud.bigtable.thirdparty.org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.serializer.WritableSerialization;

@InternalExtensionOnly
public class ImportJob {
    static final long BUNDLE_SIZE = 0x6400000L;

    public static void main(String[] args) {
        PipelineOptionsFactory.register(ImportOptions.class);
        ImportOptions opts = (ImportOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(ImportOptions.class);
        Pipeline pipeline = ImportJob.buildPipeline(opts);
        PipelineResult result = pipeline.run();
        if (opts.getWait()) {
            Utils.waitForPipelineToFinish(result);
        }
    }

    @VisibleForTesting
    static Pipeline buildPipeline(ImportOptions opts) {
        Pipeline pipeline = Pipeline.create((PipelineOptions)Utils.tweakOptions((PipelineOptions)opts));
        ((PCollection)((PCollection)pipeline.apply("Read Sequence File", (PTransform)Read.from(new ShuffledSource(ImportJob.createSource(opts.getSourcePattern()))))).apply("Create Mutations", (PTransform)ParDo.of((DoFn)new HBaseResultToMutationFn()))).apply("Write to Bigtable", ImportJob.createSink(opts));
        return pipeline;
    }

    static SequenceFileSource<ImmutableBytesWritable, Result> createSource(ValueProvider<String> sourcePattern) {
        return new SequenceFileSource<ImmutableBytesWritable, Result>(sourcePattern, ImmutableBytesWritable.class, WritableSerialization.class, Result.class, ResultSerialization.class, 0x6400000L);
    }

    static PTransform<PCollection<Mutation>, PDone> createSink(ImportOptions opts) {
        CloudBigtableTableConfiguration config = TemplateUtils.buildImportConfig(opts, "SequenceFileImportJob");
        return CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)config);
    }

    public static interface ImportOptions
    extends GcpOptions {
        @Description(value="This Bigtable App Profile id.")
        public ValueProvider<String> getBigtableAppProfileId();

        public void setBigtableAppProfileId(ValueProvider<String> var1);

        @Description(value="The project that contains the table to export. Defaults to --project.")
        @Default.InstanceFactory(value=Utils.DefaultBigtableProjectFactory.class)
        public ValueProvider<String> getBigtableProject();

        public void setBigtableProject(ValueProvider<String> var1);

        @Description(value="The Bigtable instance id that contains the table to export.")
        public ValueProvider<String> getBigtableInstanceId();

        public void setBigtableInstanceId(ValueProvider<String> var1);

        @Description(value="The Bigtable table id to export.")
        public ValueProvider<String> getBigtableTableId();

        public void setBigtableTableId(ValueProvider<String> var1);

        @Description(value="The fully qualified file pattern to import. Should of the form '[destinationPath]/part-*'")
        public ValueProvider<String> getSourcePattern();

        public void setSourcePattern(ValueProvider<String> var1);

        @Description(value="Optional Set mutation latency throttling (enables the feature). Value in milliseconds.")
        @Default.Integer(value=0)
        public ValueProvider<Integer> getMutationThrottleLatencyMs();

        public void setMutationThrottleLatencyMs(ValueProvider<Integer> var1);

        @Description(value="Wait for pipeline to finish.")
        @Default.Boolean(value=true)
        public boolean getWait();

        public void setWait(boolean var1);
    }
}

