/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.sequencefiles;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.common.base.Strings;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineDebugOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@InternalApi
public class Utils {
    private static final Log LOG = LogFactory.getLog(Utils.class);

    public static PipelineOptions tweakOptions(PipelineOptions opts) {
        if (!DataflowRunner.class.isAssignableFrom(opts.getRunner())) {
            return opts;
        }
        DataflowPipelineOptions dataflowOpts = (DataflowPipelineOptions)opts.as(DataflowPipelineOptions.class);
        if (Strings.isNullOrEmpty((String)dataflowOpts.getRegion())) {
            String zone = dataflowOpts.getWorkerZone();
            if (Strings.isNullOrEmpty((String)zone)) {
                zone = dataflowOpts.getZone();
            }
            if (!Strings.isNullOrEmpty((String)zone)) {
                String region = zone.replaceAll("-[^-]+$", "");
                dataflowOpts.setRegion(region);
            }
        }
        if (dataflowOpts.getDiskSizeGb() == 0) {
            dataflowOpts.setDiskSizeGb(25);
        }
        DataflowPipelineDebugOptions debugOptions = (DataflowPipelineDebugOptions)dataflowOpts.as(DataflowPipelineDebugOptions.class);
        debugOptions.setGCThrashingPercentagePerPeriod(Double.valueOf(100.0));
        return debugOptions;
    }

    public static void waitForPipelineToFinish(PipelineResult result) {
        try {
            result.getState();
            PipelineResult.State state = result.waitUntilFinish();
            LOG.info((Object)("Job finished with state: " + state.name()));
            if (state != PipelineResult.State.DONE) {
                System.exit(1);
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.warn((Object)"Unable to wait for pipeline to finish.", (Throwable)e);
        }
    }

    static class StringToDirectoryResourceId
    extends SimpleFunction<String, ResourceId> {
        StringToDirectoryResourceId() {
        }

        public ResourceId apply(String input) {
            return FileSystems.matchNewResource((String)input, (boolean)true);
        }
    }

    public static class DefaultBigtableProjectFactory
    implements DefaultValueFactory<String> {
        public String create(PipelineOptions options) {
            return ((GcpOptions)options.as(GcpOptions.class)).getProject();
        }
    }
}

