/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.validation;

import com.google.cloud.bigtable.beam.validation.HadoopHashTableSource;
import com.google.cloud.bigtable.beam.validation.RangeHashCoder;
import com.google.cloud.bigtable.beam.validation.SyncTableUtils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.KV;
import org.apache.hadoop.hbase.util.Bytes;

class BufferedHadoopHashTableSource
extends BoundedSource<KV<String, List<HadoopHashTableSource.RangeHash>>> {
    private static final long serialVersionUID = 39842743L;
    private static final int DEFAULT_BATCH_SIZE = 50;
    private static final Coder<KV<String, List<HadoopHashTableSource.RangeHash>>> CODER = KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)ListCoder.of(RangeHashCoder.of()));
    private final int maxBufferSize;
    private final HadoopHashTableSource hashTableSource;

    public BufferedHadoopHashTableSource(HadoopHashTableSource source) {
        this(source, 50);
    }

    public BufferedHadoopHashTableSource(HadoopHashTableSource hashTableSource, int maxBufferSize) {
        this.hashTableSource = hashTableSource;
        this.maxBufferSize = maxBufferSize;
    }

    public List<? extends BoundedSource<KV<String, List<HadoopHashTableSource.RangeHash>>>> split(long desiredBundleSizeBytes, PipelineOptions options) throws IOException {
        List<? extends BoundedSource<HadoopHashTableSource.RangeHash>> splitHashTableSources = this.hashTableSource.split(desiredBundleSizeBytes, options);
        ArrayList<BufferedHadoopHashTableSource> splitSources = new ArrayList<BufferedHadoopHashTableSource>(splitHashTableSources.size());
        for (HadoopHashTableSource hadoopHashTableSource : splitHashTableSources) {
            splitSources.add(new BufferedHadoopHashTableSource(hadoopHashTableSource));
        }
        return splitSources;
    }

    public Coder<KV<String, List<HadoopHashTableSource.RangeHash>>> getOutputCoder() {
        return CODER;
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return this.hashTableSource.getEstimatedSizeBytes(options);
    }

    public BoundedSource.BoundedReader<KV<String, List<HadoopHashTableSource.RangeHash>>> createReader(PipelineOptions options) throws IOException {
        return new BufferedHashBasedReader(this, this.hashTableSource.createReader(options));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BufferedHadoopHashTableSource)) {
            return false;
        }
        BufferedHadoopHashTableSource that = (BufferedHadoopHashTableSource)((Object)o);
        return this.maxBufferSize == that.maxBufferSize && Objects.equal((Object)this.hashTableSource, (Object)that.hashTableSource);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.maxBufferSize, this.hashTableSource});
    }

    public String toString() {
        return "BufferedHadoopHashTableSource [" + SyncTableUtils.immutableBytesToString(this.hashTableSource.startRowInclusive) + ", " + SyncTableUtils.immutableBytesToString(this.hashTableSource.stopRowExclusive) + "), maxBufferSize=" + this.maxBufferSize;
    }

    private static class BufferedHashBasedReader
    extends BoundedSource.BoundedReader<KV<String, List<HadoopHashTableSource.RangeHash>>> {
        private final BoundedSource.BoundedReader<HadoopHashTableSource.RangeHash> hashReader;
        private final BufferedHadoopHashTableSource source;
        private List<HadoopHashTableSource.RangeHash> buffer;

        public BufferedHashBasedReader(BufferedHadoopHashTableSource source, BoundedSource.BoundedReader<HadoopHashTableSource.RangeHash> hashReader) {
            this.source = source;
            this.hashReader = hashReader;
            this.buffer = new ArrayList<HadoopHashTableSource.RangeHash>(source.maxBufferSize);
        }

        public boolean start() throws IOException {
            if (!this.hashReader.start()) {
                return false;
            }
            this.buffer.add((HadoopHashTableSource.RangeHash)this.hashReader.getCurrent());
            this.bufferRangeHashes();
            return true;
        }

        private boolean bufferRangeHashes() throws IOException {
            boolean readRangeHashes = false;
            while (this.buffer.size() < this.source.maxBufferSize && this.hashReader.advance()) {
                readRangeHashes = true;
                this.buffer.add((HadoopHashTableSource.RangeHash)this.hashReader.getCurrent());
            }
            return readRangeHashes;
        }

        public boolean advance() throws IOException {
            this.buffer = new ArrayList<HadoopHashTableSource.RangeHash>(this.source.maxBufferSize);
            return this.bufferRangeHashes();
        }

        public KV<String, List<HadoopHashTableSource.RangeHash>> getCurrent() {
            Preconditions.checkState((!this.buffer.isEmpty() ? 1 : 0) != 0, (Object)"getCurrent() should only be called when start/advance return true.");
            return KV.of((Object)Bytes.toStringBinary((byte[])this.buffer.get((int)0).startInclusive.copyBytes()), this.buffer);
        }

        public void close() throws IOException {
            this.hashReader.close();
        }

        public BoundedSource<KV<String, List<HadoopHashTableSource.RangeHash>>> getCurrentSource() {
            return this.source;
        }
    }
}

