/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.validation;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.cloud.bigtable.beam.AbstractCloudBigtableTableDoFn;
import com.google.cloud.bigtable.beam.CloudBigtableConfiguration;
import com.google.cloud.bigtable.beam.TemplateUtils;
import com.google.cloud.bigtable.beam.validation.HadoopHashTableSource;
import com.google.cloud.bigtable.beam.validation.SyncTableJob;
import com.google.cloud.bigtable.beam.validation.SyncTableUtils;
import com.google.cloud.bigtable.beam.validation.TableHashWrapper;
import com.google.cloud.bigtable.beam.validation.TableHashWrapperFactory;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.BigtableTableHashAccessor;

class ComputeAndValidateHashFromBigtableDoFn
extends AbstractCloudBigtableTableDoFn<KV<String, Iterable<List<HadoopHashTableSource.RangeHash>>>, HadoopHashTableSource.RangeHash> {
    private static final long serialVersionUID = 2349094L;
    private final ValueProvider<String> tableName;
    private final ValueProvider<String> projectId;
    private final ValueProvider<String> sourceHashDir;
    private final TableHashWrapperFactory tableHashWrapperFactory;
    private final Counter matches = Metrics.counter((String)"cbt-dataflow-validate", (String)"ranges_matched");
    private final Counter mismatches = Metrics.counter((String)"cbt-dataflow-validate", (String)"ranges_not_matched");

    public ComputeAndValidateHashFromBigtableDoFn(SyncTableJob.SyncTableOptions options) {
        super((CloudBigtableConfiguration)TemplateUtils.buildSyncTableConfig(options));
        this.tableName = options.getBigtableTableId();
        this.projectId = options.getBigtableProject();
        this.sourceHashDir = options.getHashTableOutputDir();
        this.tableHashWrapperFactory = new TableHashWrapperFactory();
    }

    @VisibleForTesting
    ComputeAndValidateHashFromBigtableDoFn(CloudBigtableConfiguration config, ValueProvider<String> tableName, ValueProvider<String> projectId, ValueProvider<String> sourceHashDir, TableHashWrapperFactory factory) {
        super(config);
        this.tableName = tableName;
        this.tableHashWrapperFactory = factory;
        this.sourceHashDir = projectId;
        this.projectId = sourceHashDir;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) throws Exception {
        ArrayList wrapperdRangeHashes = Lists.newArrayList((Iterable)((Iterable)((KV)context.element()).getValue()));
        Preconditions.checkState((wrapperdRangeHashes.size() == 1 ? 1 : 0) != 0, (Object)"Can not have multiple entries for a key");
        List rangeHashes = (List)wrapperdRangeHashes.get(0);
        Preconditions.checkState((!rangeHashes.isEmpty() ? 1 : 0) != 0, (Object)"Can not have empty ranges in DO_FN");
        this.mismatches.inc(0L);
        this.matches.inc(0L);
        ImmutableBytesWritable rangeStartInclusive = ((HadoopHashTableSource.RangeHash)rangeHashes.get((int)0)).startInclusive;
        ImmutableBytesWritable rangeEndExclusive = ((HadoopHashTableSource.RangeHash)rangeHashes.get((int)(rangeHashes.size() - 1))).stopExclusive;
        BigtableTableHashAccessor.BigtableResultHasher resultHasher = new BigtableTableHashAccessor.BigtableResultHasher();
        resultHasher.startBatch(rangeStartInclusive);
        ResultScanner scanner = this.createBigtableScan(rangeStartInclusive.copyBytes(), rangeEndExclusive.copyBytes());
        Iterator rangeHashIterator = rangeHashes.iterator();
        long numRows = 0L;
        HadoopHashTableSource.RangeHash currentRangeHash = (HadoopHashTableSource.RangeHash)rangeHashIterator.next();
        for (Result result : scanner) {
            if (++numRows % 10000L == 0L) {
                this.DOFN_LOG.debug("Processed " + numRows + " rows ");
            }
            ImmutableBytesWritable rowKey = new ImmutableBytesWritable(result.getRow());
            while (!ComputeAndValidateHashFromBigtableDoFn.isWithinUpperBound(currentRangeHash.stopExclusive, rowKey)) {
                this.validateBatchHash(context, resultHasher, currentRangeHash);
                Preconditions.checkState((boolean)rangeHashIterator.hasNext(), (Object)("Buffer reached to end while scan is still active at row : %s. Affected Range: [%s, %s)." + SyncTableUtils.immutableBytesToString(result.getRow()) + SyncTableUtils.immutableBytesToString(rangeStartInclusive) + SyncTableUtils.immutableBytesToString(rangeEndExclusive)));
                currentRangeHash = (HadoopHashTableSource.RangeHash)rangeHashIterator.next();
            }
            resultHasher.hashResult(result);
        }
        this.validateBatchHash(context, resultHasher, currentRangeHash);
        while (rangeHashIterator.hasNext()) {
            currentRangeHash = (HadoopHashTableSource.RangeHash)rangeHashIterator.next();
            this.reportMismatch(context, currentRangeHash);
        }
        this.DOFN_LOG.debug("Finishing context by outputting {}  keys in range [{}, {}).", new Object[]{rangeHashes.size(), SyncTableUtils.immutableBytesToString(rangeStartInclusive), SyncTableUtils.immutableBytesToString(rangeEndExclusive)});
    }

    private ResultScanner createBigtableScan(byte[] startKeyInclusive, byte[] stopKeyExclusive) throws IOException {
        Table table = this.getConnection().getTable(TableName.valueOf((String)((String)this.tableName.get())));
        TableHashWrapper tableHash = this.tableHashWrapperFactory.getTableHash((String)this.projectId.get(), (String)this.sourceHashDir.get());
        Scan scan = tableHash.getScan();
        if (startKeyInclusive.length > 0) {
            scan.withStartRow(startKeyInclusive, true);
        }
        if (stopKeyExclusive.length > 0) {
            scan.withStopRow(stopKeyExclusive, false);
        }
        return table.getScanner(scan);
    }

    private static boolean isWithinUpperBound(ImmutableBytesWritable stopExclusive, ImmutableBytesWritable row) {
        return stopExclusive.equals((Object)HConstants.EMPTY_END_ROW) || row.compareTo(stopExclusive) < 0;
    }

    private void validateBatchHash(DoFn.ProcessContext context, BigtableTableHashAccessor.BigtableResultHasher resultHasher, HadoopHashTableSource.RangeHash currentRangeHash) {
        resultHasher.finishBatch();
        if (!resultHasher.getBatchHash().equals((Object)currentRangeHash.hash)) {
            this.reportMismatch(context, currentRangeHash);
        } else {
            this.matches.inc();
        }
        resultHasher.startBatch(currentRangeHash.stopExclusive);
    }

    private void reportMismatch(DoFn.ProcessContext context, HadoopHashTableSource.RangeHash currentRangeHash) {
        this.mismatches.inc();
        this.DOFN_LOG.info("MISMATCH ON RANGE [{}, {}).", (Object)SyncTableUtils.immutableBytesToString(currentRangeHash.startInclusive), (Object)SyncTableUtils.immutableBytesToString(currentRangeHash.stopExclusive));
        context.output((Object)currentRangeHash);
    }
}

