/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam.validation;

import com.google.cloud.bigtable.beam.validation.HadoopHashTableSource;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

public class RangeHashCoder
extends Coder<HadoopHashTableSource.RangeHash> {
    public static Coder<HadoopHashTableSource.RangeHash> of() {
        return new RangeHashCoder();
    }

    public void encode(HadoopHashTableSource.RangeHash value, OutputStream outStream) throws IOException {
        if (value == null) {
            throw new CoderException("Can not encode null objects.");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outStream);
        value.startInclusive.write((DataOutput)dataOutputStream);
        value.stopExclusive.write((DataOutput)dataOutputStream);
        value.hash.write((DataOutput)dataOutputStream);
    }

    public HadoopHashTableSource.RangeHash decode(InputStream inStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inStream);
        ImmutableBytesWritable startInclusive = new ImmutableBytesWritable();
        startInclusive.readFields((DataInput)dataInputStream);
        ImmutableBytesWritable stopExclusive = new ImmutableBytesWritable();
        stopExclusive.readFields((DataInput)dataInputStream);
        ImmutableBytesWritable hash = new ImmutableBytesWritable();
        hash.readFields((DataInput)dataInputStream);
        return HadoopHashTableSource.RangeHash.of(startInclusive, stopExclusive, hash);
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return Collections.emptyList();
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Hash data required");
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object other) {
        return other instanceof RangeHashCoder;
    }

    public int hashCode() {
        return RangeHashCoder.class.hashCode();
    }
}

