/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.json.GenericJson;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.DefaultCredentialsProvider;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.UserCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleCredentials
extends OAuth2Credentials {
    static final String USER_FILE_TYPE = "authorized_user";
    static final String SERVICE_ACCOUNT_FILE_TYPE = "service_account";
    private static final DefaultCredentialsProvider defaultCredentialsProvider = new DefaultCredentialsProvider();

    public static GoogleCredentials getApplicationDefault() throws IOException {
        return GoogleCredentials.getApplicationDefault(OAuth2Utils.HTTP_TRANSPORT);
    }

    public static GoogleCredentials getApplicationDefault(HttpTransport transport) throws IOException {
        Preconditions.checkNotNull(transport);
        return defaultCredentialsProvider.getDefaultCredentials(transport);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream) throws IOException {
        return GoogleCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT);
    }

    public static GoogleCredentials fromStream(InputStream credentialsStream, HttpTransport transport) throws IOException {
        Preconditions.checkNotNull(credentialsStream);
        Preconditions.checkNotNull(transport);
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson fileContents = parser.parseAndClose(credentialsStream, OAuth2Utils.UTF_8, GenericJson.class);
        String fileType = (String)fileContents.get("type");
        if (fileType == null) {
            throw new IOException("Error reading credentials from stream, 'type' field not specified.");
        }
        if (USER_FILE_TYPE.equals(fileType)) {
            return UserCredentials.fromJson(fileContents, transport);
        }
        if (SERVICE_ACCOUNT_FILE_TYPE.equals(fileType)) {
            return ServiceAccountCredentials.fromJson(fileContents, transport);
        }
        throw new IOException(String.format("Error reading credentials from stream, 'type' value '%s' not recognized. Expecting '%s' or '%s'.", fileType, USER_FILE_TYPE, SERVICE_ACCOUNT_FILE_TYPE));
    }

    protected GoogleCredentials() {
        this(null);
    }

    public GoogleCredentials(AccessToken accessToken) {
        super(accessToken);
    }

    public boolean createScopedRequired() {
        return false;
    }

    public GoogleCredentials createScoped(Collection<String> scopes) {
        return this;
    }
}

