/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponse;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.http.UrlEncodedContent;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.bigtable.repackaged.com.google.api.client.util.GenericData;
import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCredentials
extends GoogleCredentials {
    private static final String GRANT_TYPE = "refresh_token";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private final String clientId;
    private final String clientSecret;
    private final String refreshToken;
    private final HttpTransport transport;
    private final URI tokenServerUri;

    public UserCredentials(String clientId, String clientSecret, String refreshToken) {
        this(clientId, clientSecret, refreshToken, null, null, null);
    }

    public UserCredentials(String clientId, String clientSecret, String refreshToken, AccessToken accessToken) {
        this(clientId, clientSecret, refreshToken, accessToken, null, null);
    }

    public UserCredentials(String clientId, String clientSecret, String refreshToken, AccessToken accessToken, HttpTransport transport, URI tokenServerUri) {
        super(accessToken);
        this.clientId = Preconditions.checkNotNull(clientId);
        this.clientSecret = Preconditions.checkNotNull(clientSecret);
        this.refreshToken = refreshToken;
        this.transport = transport == null ? OAuth2Utils.HTTP_TRANSPORT : transport;
        this.tokenServerUri = tokenServerUri == null ? OAuth2Utils.TOKEN_SERVER_URI : tokenServerUri;
        Preconditions.checkState(accessToken != null || refreshToken != null, "Either accessToken or refreshToken must not be null");
    }

    static UserCredentials fromJson(Map<String, Object> json, HttpTransport transport) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientSecret = (String)json.get("client_secret");
        String refreshToken = (String)json.get(GRANT_TYPE);
        if (clientId == null || clientSecret == null || refreshToken == null) {
            throw new IOException("Error reading user credential from JSON,  expecting 'client_id', 'client_secret' and 'refresh_token'.");
        }
        UserCredentials credentials = new UserCredentials(clientId, clientSecret, refreshToken, null, transport, null);
        return credentials;
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        if (this.refreshToken == null) {
            throw new IllegalStateException("UserCredentials instance cannot refresh because there is no refresh token.");
        }
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("client_id", this.clientId);
        tokenRequest.set("client_secret", this.clientSecret);
        tokenRequest.set(GRANT_TYPE, this.refreshToken);
        tokenRequest.set("grant_type", GRANT_TYPE);
        UrlEncodedContent content = new UrlEncodedContent(tokenRequest);
        HttpRequestFactory requestFactory = this.transport.createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), content);
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        HttpResponse response = request.execute();
        GenericData responseData = response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)(expiresInSeconds * 1000);
        AccessToken access = new AccessToken(accessToken, new Date(expiresAtMilliseconds));
        return access;
    }

    public final String getRefreshToken() {
        return this.refreshToken;
    }
}

