/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.protobuf;

final class Utf8 {
    static final int MAX_BYTES_PER_CHAR = 3;
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;

    private Utf8() {
    }

    public static boolean isValidUtf8(byte[] bytes) {
        return Utf8.isValidUtf8(bytes, 0, bytes.length);
    }

    public static boolean isValidUtf8(byte[] bytes, int index, int limit) {
        return Utf8.partialIsValidUtf8(bytes, index, limit) == 0;
    }

    public static int partialIsValidUtf8(int state, byte[] bytes, int index, int limit) {
        if (state != 0) {
            if (index >= limit) {
                return state;
            }
            byte byte1 = (byte)state;
            if (byte1 < -32) {
                if (byte1 < -62 || bytes[index++] > -65) {
                    return -1;
                }
            } else if (byte1 < -16) {
                byte byte2 = (byte)(~(state >> 8));
                if (byte2 == 0) {
                    byte2 = bytes[index++];
                    if (index >= limit) {
                        return Utf8.incompleteStateFor(byte1, byte2);
                    }
                }
                if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || bytes[index++] > -65) {
                    return -1;
                }
            } else {
                byte byte2 = (byte)(~(state >> 8));
                byte byte3 = 0;
                if (byte2 == 0) {
                    byte2 = bytes[index++];
                    if (index >= limit) {
                        return Utf8.incompleteStateFor(byte1, byte2);
                    }
                } else {
                    byte3 = (byte)(state >> 16);
                }
                if (byte3 == 0) {
                    byte3 = bytes[index++];
                    if (index >= limit) {
                        return Utf8.incompleteStateFor(byte1, (int)byte2, (int)byte3);
                    }
                }
                if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || bytes[index++] > -65) {
                    return -1;
                }
            }
        }
        return Utf8.partialIsValidUtf8(bytes, index, limit);
    }

    public static int partialIsValidUtf8(byte[] bytes, int index, int limit) {
        while (index < limit && bytes[index] >= 0) {
            ++index;
        }
        return index >= limit ? 0 : Utf8.partialIsValidUtf8NonAscii(bytes, index, limit);
    }

    private static int partialIsValidUtf8NonAscii(byte[] bytes, int index, int limit) {
        while (true) {
            byte byte2;
            byte byte1;
            if (index >= limit) {
                return 0;
            }
            if ((byte1 = bytes[index++]) >= 0) continue;
            if (byte1 < -32) {
                if (index >= limit) {
                    return byte1;
                }
                if (byte1 >= -62 && bytes[index++] <= -65) continue;
                return -1;
            }
            if (byte1 < -16) {
                if (index >= limit - 1) {
                    return Utf8.incompleteStateFor(bytes, index, limit);
                }
                if (!((byte2 = bytes[index++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && bytes[index++] <= -65) continue;
                return -1;
            }
            if (index >= limit - 2) {
                return Utf8.incompleteStateFor(bytes, index, limit);
            }
            if ((byte2 = bytes[index++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes[index++] > -65 || bytes[index++] > -65) break;
        }
        return -1;
    }

    private static int incompleteStateFor(int byte1) {
        return byte1 > -12 ? -1 : byte1;
    }

    private static int incompleteStateFor(int byte1, int byte2) {
        return byte1 > -12 || byte2 > -65 ? -1 : byte1 ^ byte2 << 8;
    }

    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        return byte1 > -12 || byte2 > -65 || byte3 > -65 ? -1 : byte1 ^ byte2 << 8 ^ byte3 << 16;
    }

    private static int incompleteStateFor(byte[] bytes, int index, int limit) {
        byte byte1 = bytes[index - 1];
        switch (limit - index) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, bytes[index]);
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)bytes[index], (int)bytes[index + 1]);
            }
        }
        throw new AssertionError();
    }

    static int encodedLength(CharSequence sequence) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                throw new UnpairedSurrogateException(i);
            }
            ++i;
        }
        return utf8Length;
    }

    static int encode(CharSequence sequence, byte[] bytes, int offset, int length) {
        char c;
        int i;
        int utf16Length = sequence.length();
        int j = offset;
        int limit = offset + length;
        for (i = 0; i < utf16Length && i + j < limit && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            bytes[j + i] = (byte)c;
        }
        if (i == utf16Length) {
            return j + utf16Length;
        }
        j += i;
        while (i < utf16Length) {
            c = sequence.charAt(i);
            if (c < '\u0080' && j < limit) {
                bytes[j++] = (byte)c;
            } else if (c < '\u0800' && j <= limit - 2) {
                bytes[j++] = (byte)(0x3C0 | c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                bytes[j++] = (byte)(0x1E0 | c >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & c);
            } else if (j <= limit - 4) {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    throw new UnpairedSurrogateException(i - 1);
                }
                int codePoint = Character.toCodePoint(c, low);
                bytes[j++] = (byte)(0xF0 | codePoint >>> 18);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                bytes[j++] = (byte)(0x80 | 0x3F & codePoint);
            } else {
                if (!('\ud800' > c || c > '\udfff' || i + 1 != sequence.length() && Character.isSurrogatePair(c, sequence.charAt(i + 1)))) {
                    throw new UnpairedSurrogateException(i);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
            }
            ++i;
        }
        return j;
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        private UnpairedSurrogateException(int index) {
            super("Unpaired surrogate at index " + index);
        }
    }
}

