/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.io.grpc.RequestKey;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CallOptions {
    public static final CallOptions DEFAULT = new CallOptions();
    private Long deadlineNanoTime;
    @Nullable
    private String authority;
    @Nullable
    private RequestKey requestKey;

    public CallOptions withAuthority(@Nullable String authority) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.authority = authority;
        return newOptions;
    }

    public CallOptions withDeadlineNanoTime(@Nullable Long deadlineNanoTime) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.deadlineNanoTime = deadlineNanoTime;
        return newOptions;
    }

    public CallOptions withDeadlineAfter(long duration, TimeUnit unit) {
        return this.withDeadlineNanoTime(System.nanoTime() + unit.toNanos(duration));
    }

    @Nullable
    public Long getDeadlineNanoTime() {
        return this.deadlineNanoTime;
    }

    public CallOptions withRequestKey(@Nullable RequestKey requestKey) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.requestKey = requestKey;
        return newOptions;
    }

    @Nullable
    public RequestKey getRequestKey() {
        return this.requestKey;
    }

    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    private CallOptions() {
    }

    private CallOptions(CallOptions other) {
        this.deadlineNanoTime = other.deadlineNanoTime;
        this.authority = other.authority;
        this.requestKey = other.requestKey;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this);
        toStringHelper.add("deadlineNanoTime", this.deadlineNanoTime);
        if (this.deadlineNanoTime != null) {
            long remainingNanos = this.deadlineNanoTime - System.nanoTime();
            toStringHelper.addValue(remainingNanos + " ns from now");
        }
        toStringHelper.add("authority", this.authority);
        return toStringHelper.toString();
    }
}

