/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.ForwardingServerCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.ServerCall;
import com.google.bigtable.repackaged.io.grpc.ServerCallHandler;

public class Contexts {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(Context context, MethodDescriptor<ReqT, RespT> method, ServerCall<RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context previous = context.attach();
        try {
            ContextualizedServerCallListener<ReqT> contextualizedServerCallListener = new ContextualizedServerCallListener<ReqT>(next.startCall(method, call, headers), context);
            return contextualizedServerCallListener;
        }
        finally {
            context.detach(previous);
        }
    }

    private static class ContextualizedServerCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private final Context context;

        public ContextualizedServerCallListener(ServerCall.Listener<ReqT> delegate, Context context) {
            super(delegate);
            this.context = context;
        }

        @Override
        public void onMessage(ReqT message) {
            Context previous = this.context.attach();
            try {
                super.onMessage(message);
            }
            finally {
                this.context.detach(previous);
            }
        }

        @Override
        public void onHalfClose() {
            Context previous = this.context.attach();
            try {
                super.onHalfClose();
            }
            finally {
                this.context.detach(previous);
            }
        }

        @Override
        public void onCancel() {
            Context previous = this.context.attach();
            try {
                super.onCancel();
            }
            finally {
                this.context.detach(previous);
            }
        }

        @Override
        public void onComplete() {
            Context previous = this.context.attach();
            try {
                super.onComplete();
            }
            finally {
                this.context.detach(previous);
            }
        }

        @Override
        public void onReady() {
            Context previous = this.context.attach();
            try {
                super.onReady();
            }
            finally {
                this.context.detach(previous);
            }
        }
    }
}

