/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.ResolvedServerInfo;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

final class DnsNameResolver
extends NameResolver {
    private final String authority;
    private final String host;
    private final int port;
    private ExecutorService executor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DnsNameResolver(@Nullable String nsAuthority, String name, Attributes params) {
        URI nameUri = URI.create("//" + name);
        this.authority = Preconditions.checkNotNull(nameUri.getAuthority(), "nameUri (%s) doesn't have an authority", nameUri);
        this.host = Preconditions.checkNotNull(nameUri.getHost(), "host");
        if (nameUri.getPort() == -1) {
            Integer defaultPort = params.get(NameResolver.Factory.PARAMS_DEFAULT_PORT);
            if (defaultPort == null) throw new IllegalArgumentException("name '" + name + "' doesn't contain a port, and default port is not set in params");
            this.port = defaultPort;
            return;
        } else {
            this.port = nameUri.getPort();
        }
    }

    @Override
    public String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public synchronized void start(final NameResolver.Listener listener) {
        Preconditions.checkState(this.executor == null, "already started");
        this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                InetAddress[] inetAddrs;
                try {
                    inetAddrs = InetAddress.getAllByName(DnsNameResolver.this.host);
                }
                catch (Exception e) {
                    listener.onError(Status.UNAVAILABLE.withCause(e));
                    return;
                }
                ArrayList<ResolvedServerInfo> servers = new ArrayList<ResolvedServerInfo>(inetAddrs.length);
                for (int i = 0; i < inetAddrs.length; ++i) {
                    InetAddress inetAddr = inetAddrs[i];
                    servers.add(new ResolvedServerInfo(new InetSocketAddress(inetAddr, DnsNameResolver.this.port), Attributes.EMPTY));
                }
                listener.onUpdate(servers, Attributes.EMPTY);
            }
        });
    }

    @Override
    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor = SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, this.executor);
        }
    }

    int getPort() {
        return this.port;
    }
}

