/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;

public abstract class ManagedChannelProvider {
    private static final ManagedChannelProvider provider = ManagedChannelProvider.load(ManagedChannelProvider.getCorrectClassLoader());

    @VisibleForTesting
    static ManagedChannelProvider load(ClassLoader classLoader) {
        ServiceLoader<ManagedChannelProvider> providers = ServiceLoader.load(ManagedChannelProvider.class, classLoader);
        ArrayList<ManagedChannelProvider> list = new ArrayList<ManagedChannelProvider>();
        for (ManagedChannelProvider current : providers) {
            if (!current.isAvailable()) continue;
            list.add(current);
        }
        if (list.isEmpty()) {
            return null;
        }
        return Collections.max(list, new Comparator<ManagedChannelProvider>(){

            @Override
            public int compare(ManagedChannelProvider f1, ManagedChannelProvider f2) {
                return f1.priority() - f2.priority();
            }
        });
    }

    public static ManagedChannelProvider provider() {
        if (provider == null) {
            throw new ProviderNotFoundException("No functional channel service provider found. Try adding a dependency on the grpc-okhttp or grpc-netty artifact");
        }
        return provider;
    }

    private static ClassLoader getCorrectClassLoader() {
        if (ManagedChannelProvider.isAndroid()) {
            return ManagedChannelProvider.class.getClassLoader();
        }
        return Thread.currentThread().getContextClassLoader();
    }

    protected static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    protected abstract ManagedChannelBuilder<?> builderForAddress(String var1, int var2);

    protected abstract ManagedChannelBuilder<?> builderForTarget(String var1);

    public static final class ProviderNotFoundException
    extends RuntimeException {
        public ProviderNotFoundException(String msg) {
            super(msg);
        }
    }
}

