/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MethodDescriptor<ReqT, RespT> {
    private final MethodType type;
    private final String fullMethodName;
    private final Marshaller<ReqT> requestMarshaller;
    private final Marshaller<RespT> responseMarshaller;

    public static <RequestT, ResponseT> MethodDescriptor<RequestT, ResponseT> create(MethodType type, String fullMethodName, Marshaller<RequestT> requestMarshaller, Marshaller<ResponseT> responseMarshaller) {
        return new MethodDescriptor<RequestT, ResponseT>(type, fullMethodName, requestMarshaller, responseMarshaller);
    }

    private MethodDescriptor(MethodType type, String fullMethodName, Marshaller<ReqT> requestMarshaller, Marshaller<RespT> responseMarshaller) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.fullMethodName = Preconditions.checkNotNull(fullMethodName, "fullMethodName");
        this.requestMarshaller = Preconditions.checkNotNull(requestMarshaller, "requestMarshaller");
        this.responseMarshaller = Preconditions.checkNotNull(responseMarshaller, "responseMarshaller");
    }

    public MethodType getType() {
        return this.type;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public RespT parseResponse(InputStream input) {
        return this.responseMarshaller.parse(input);
    }

    public InputStream streamRequest(ReqT requestMessage) {
        return this.requestMarshaller.stream(requestMessage);
    }

    public ReqT parseRequest(InputStream input) {
        return this.requestMarshaller.parse(input);
    }

    public InputStream streamResponse(RespT response) {
        return this.responseMarshaller.stream(response);
    }

    public static String generateFullMethodName(String fullServiceName, String methodName) {
        return fullServiceName + "/" + methodName;
    }

    @Nullable
    public static String extractFullServiceName(String fullMethodName) {
        int index = fullMethodName.lastIndexOf("/");
        if (index == -1) {
            return null;
        }
        return fullMethodName.substring(0, index);
    }

    public static interface Marshaller<T> {
        public InputStream stream(T var1);

        public T parse(InputStream var1);
    }

    public static enum MethodType {
        UNARY,
        CLIENT_STREAMING,
        SERVER_STREAMING,
        BIDI_STREAMING,
        UNKNOWN;


        public final boolean clientSendsOneMessage() {
            return this == UNARY || this == SERVER_STREAMING;
        }

        public final boolean serverSendsOneMessage() {
            return this == UNARY || this == CLIENT_STREAMING;
        }
    }
}

