/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.inprocess;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.inprocess.InProcessTransport;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractManagedChannelImplBuilder;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractReferenceCounted;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransportFactory;
import java.net.SocketAddress;

public class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final String name;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    private InProcessChannelBuilder(String name) {
        super(new InProcessSocketAddress(name), "localhost");
        this.name = Preconditions.checkNotNull(name);
    }

    @Override
    public InProcessChannelBuilder usePlaintext(boolean skipNegotiation) {
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name);
    }

    private static class InProcessSocketAddress
    extends SocketAddress {
        final String name;

        InProcessSocketAddress(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class InProcessClientTransportFactory
    extends AbstractReferenceCounted
    implements ClientTransportFactory {
        private final String name;

        private InProcessClientTransportFactory(String name) {
            this.name = name;
        }

        @Override
        public ClientTransport newClientTransport(SocketAddress addr, String authority) {
            return new InProcessTransport(this.name);
        }

        @Override
        protected void deallocate() {
        }
    }
}

