/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.NameResolverRegistry;
import com.google.bigtable.repackaged.io.grpc.ResolvedServerInfo;
import com.google.bigtable.repackaged.io.grpc.SimpleLoadBalancerFactory;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransportFactory;
import com.google.bigtable.repackaged.io.grpc.internal.ExponentialBackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ManagedChannelImpl;
import com.google.bigtable.repackaged.io.grpc.internal.ReferenceCounted;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    @Nullable
    private Executor executor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    private String userAgent;
    @Nullable
    private String authorityOverride;
    @Nullable
    private NameResolver.Factory nameResolverFactory;
    @Nullable
    private LoadBalancer.Factory loadBalancerFactory;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;

    protected AbstractManagedChannelImplBuilder(String target) {
        this.target = Preconditions.checkNotNull(target);
        this.directServerAddress = null;
    }

    protected AbstractManagedChannelImplBuilder(SocketAddress directServerAddress, String authority) {
        this.target = "directaddress:///" + directServerAddress;
        this.directServerAddress = directServerAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(directServerAddress, authority);
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    @Override
    public final T intercept(ClientInterceptor ... interceptors) {
        return (T)this.intercept((List)Arrays.asList(interceptors));
    }

    @Override
    public final T nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of NameResolverFactory", this.directServerAddress);
        this.nameResolverFactory = resolverFactory;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of LoadBalancerFactory", this.directServerAddress);
        this.loadBalancerFactory = loadBalancerFactory;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }

    @Override
    public final T userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this.thisT();
    }

    @Override
    public final T overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this.thisT();
    }

    protected String checkAuthority(String authority) {
        return GrpcUtil.checkAuthority(authority);
    }

    @Override
    public ManagedChannelImpl build() {
        AuthorityOverridingTransportFactory transportFactory = new AuthorityOverridingTransportFactory(this.buildTransportFactory(), this.authorityOverride);
        return new ManagedChannelImpl(this.target, new ExponentialBackoffPolicy.Provider(), MoreObjects.firstNonNull(this.nameResolverFactory, NameResolverRegistry.getDefaultRegistry()), this.getNameResolverParams(), MoreObjects.firstNonNull(this.loadBalancerFactory, SimpleLoadBalancerFactory.getInstance()), transportFactory, MoreObjects.firstNonNull(this.decompressorRegistry, DecompressorRegistry.getDefaultInstance()), MoreObjects.firstNonNull(this.compressorRegistry, CompressorRegistry.getDefaultInstance()), this.executor, this.userAgent, this.interceptors);
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected Attributes getNameResolverParams() {
        return Attributes.EMPTY;
    }

    private static class DirectAddressNameResolverFactory
    extends NameResolver.Factory {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress address, String authority) {
            this.address = address;
            this.authority = authority;
        }

        @Override
        public NameResolver newNameResolver(URI notUsedUri, Attributes params) {
            return new NameResolver(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(NameResolver.Listener listener) {
                    listener.onUpdate(Collections.singletonList(new ResolvedServerInfo(DirectAddressNameResolverFactory.this.address, Attributes.EMPTY)), Attributes.EMPTY);
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return AbstractManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }

    private static class AuthorityOverridingTransportFactory
    implements ClientTransportFactory {
        final ClientTransportFactory factory;
        @Nullable
        final String authorityOverride;

        AuthorityOverridingTransportFactory(ClientTransportFactory factory, @Nullable String authorityOverride) {
            this.factory = factory;
            this.authorityOverride = authorityOverride;
        }

        @Override
        public ClientTransport newClientTransport(SocketAddress serverAddress, String authority) {
            return this.factory.newClientTransport(serverAddress, this.authorityOverride != null ? this.authorityOverride : authority);
        }

        @Override
        public int referenceCount() {
            return this.factory.referenceCount();
        }

        @Override
        public ReferenceCounted retain() {
            this.factory.retain();
            return this;
        }

        @Override
        public ReferenceCounted release() {
            this.factory.release();
            return this;
        }
    }
}

