/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.io.grpc.internal.ReferenceCounted;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractReferenceCounted
implements ReferenceCounted {
    private final AtomicInteger refCount = new AtomicInteger(1);

    @Override
    public final int referenceCount() {
        return this.refCount.get();
    }

    @Override
    public final ReferenceCounted retain() {
        int newCount = this.refCount.incrementAndGet();
        if (newCount <= 1) {
            throw this.illegalReferenceCount(newCount);
        }
        return this;
    }

    @Override
    public final ReferenceCounted release() {
        int newCount = this.refCount.decrementAndGet();
        if (newCount < 0) {
            throw this.illegalReferenceCount(newCount);
        }
        if (newCount == 0) {
            this.deallocate();
        }
        return this;
    }

    protected abstract void deallocate();

    private IllegalStateException illegalReferenceCount(int count) {
        throw new IllegalStateException(String.format("Illegal reference count for class %s: %d", this.getClass().getName(), count));
    }
}

