/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.HandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.MutableHandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.MutableHandlerRegistryImpl;
import com.google.bigtable.repackaged.io.grpc.ServerBuilder;
import com.google.bigtable.repackaged.io.grpc.ServerServiceDefinition;
import com.google.bigtable.repackaged.io.grpc.internal.Server;
import com.google.bigtable.repackaged.io.grpc.internal.ServerImpl;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private final HandlerRegistry registry;
    @Nullable
    private Executor executor;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;

    protected AbstractServerImplBuilder(HandlerRegistry registry) {
        this.registry = Preconditions.checkNotNull(registry);
    }

    protected AbstractServerImplBuilder() {
        this.registry = new MutableHandlerRegistryImpl();
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        if (this.registry instanceof MutableHandlerRegistry) {
            ((MutableHandlerRegistry)this.registry).addService(service);
            return this.thisT();
        }
        throw new UnsupportedOperationException("Underlying HandlerRegistry is not mutable");
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    protected final DecompressorRegistry decompressorRegistry() {
        return this.decompressorRegistry;
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    protected final CompressorRegistry compressorRegistry() {
        return this.compressorRegistry;
    }

    @Override
    public ServerImpl build() {
        Server transportServer = this.buildTransportServer();
        return new ServerImpl(this.executor, this.registry, transportServer, Context.ROOT);
    }

    protected abstract Server buildTransportServer();

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

