/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Compressor;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractStream;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ReadableBuffer;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStream;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBuffer;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBufferAllocator;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractServerStream<IdT>
extends AbstractStream<IdT>
implements ServerStream {
    private static final Logger log = Logger.getLogger(AbstractServerStream.class.getName());
    private boolean listenerClosed;
    private ServerStreamListener listener;
    private boolean headersSent = false;
    private String messageEncoding;
    private boolean gracefulClose;
    private Metadata stashedTrailers;

    protected AbstractServerStream(WritableBufferAllocator bufferAllocator, int maxMessageSize) {
        super(bufferAllocator, maxMessageSize);
    }

    public final void setListener(ServerStreamListener listener) {
        this.listener = Preconditions.checkNotNull(listener);
        this.onStreamAllocated();
    }

    @Override
    protected ServerStreamListener listener() {
        return this.listener;
    }

    @Override
    protected void receiveMessage(InputStream is) {
        this.inboundPhase(AbstractStream.Phase.MESSAGE);
        this.listener().messageRead(is);
    }

    @Override
    public final void writeHeaders(Metadata headers) {
        Preconditions.checkNotNull(headers, "headers");
        headers.removeAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (this.messageEncoding != null) {
            headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, this.messageEncoding);
        }
        headers.removeAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        if (!this.decompressorRegistry().getAdvertisedMessageEncodings().isEmpty()) {
            String acceptEncoding = GrpcUtil.ACCEPT_ENCODING_JOINER.join(this.decompressorRegistry().getAdvertisedMessageEncodings());
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, acceptEncoding);
        }
        this.outboundPhase(AbstractStream.Phase.HEADERS);
        this.headersSent = true;
        this.internalSendHeaders(headers);
        this.outboundPhase(AbstractStream.Phase.MESSAGE);
    }

    @Override
    public final void writeMessage(InputStream message) {
        if (this.outboundPhase() != AbstractStream.Phase.MESSAGE) {
            throw new IllegalStateException("Messages are only permitted after headers and before close");
        }
        super.writeMessage(message);
    }

    @Override
    public final void close(Status status, Metadata trailers) {
        Preconditions.checkNotNull(status, "status");
        Preconditions.checkNotNull(trailers, "trailers");
        if (this.outboundPhase(AbstractStream.Phase.STATUS) != AbstractStream.Phase.STATUS) {
            this.gracefulClose = true;
            this.stashedTrailers = trailers;
            this.writeStatusToTrailers(status);
            this.closeFramer();
        }
    }

    private void writeStatusToTrailers(Status status) {
        this.stashedTrailers.removeAll(Status.CODE_KEY);
        this.stashedTrailers.removeAll(Status.MESSAGE_KEY);
        this.stashedTrailers.put(Status.CODE_KEY, status);
        if (status.getDescription() != null) {
            this.stashedTrailers.put(Status.MESSAGE_KEY, status.getDescription());
        }
    }

    protected void inboundHeadersReceived(Metadata headers) {
        Compressor c;
        if (headers.containsKey(GrpcUtil.MESSAGE_ENCODING_KEY)) {
            String messageEncoding = headers.get(GrpcUtil.MESSAGE_ENCODING_KEY);
            try {
                this.setDecompressor(messageEncoding);
            }
            catch (IllegalArgumentException e) {
                Status status = Status.INVALID_ARGUMENT.withDescription("Unable to decompress encoding " + messageEncoding).withCause(e);
                this.abortStream(status, true);
                return;
            }
        }
        if (headers.containsKey(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY) && (c = this.pickCompressor(GrpcUtil.ACCEPT_ENCODING_SPLITER.split(headers.get(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY)))) != null) {
            this.messageEncoding = c.getMessageEncoding();
        }
        this.inboundPhase(AbstractStream.Phase.MESSAGE);
    }

    public void inboundDataReceived(ReadableBuffer frame, boolean endOfStream) {
        if (this.inboundPhase() == AbstractStream.Phase.STATUS) {
            frame.close();
            return;
        }
        this.deframe(frame, endOfStream);
    }

    @Override
    protected final void deframeFailed(Throwable cause) {
        log.log(Level.WARNING, "Exception processing message", cause);
        this.abortStream(Status.fromThrowable(cause), true);
    }

    @Override
    protected final void internalSendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        if (frame != null) {
            this.sendFrame(frame, false, endOfStream ? false : flush);
        }
        if (endOfStream) {
            this.sendTrailers(this.stashedTrailers, this.headersSent);
            this.headersSent = true;
            this.stashedTrailers = null;
        }
    }

    protected abstract void internalSendHeaders(Metadata var1);

    protected abstract void sendFrame(WritableBuffer var1, boolean var2, boolean var3);

    protected abstract void sendTrailers(Metadata var1, boolean var2);

    public void complete() {
        if (!this.gracefulClose) {
            this.closeListener(Status.INTERNAL.withDescription("successful complete() without close()"));
            throw new IllegalStateException("successful complete() without close()");
        }
        this.closeListener(Status.OK);
    }

    @Override
    protected final void remoteEndClosed() {
        this.halfCloseListener();
    }

    public final void abortStream(Status status, boolean notifyClient) {
        Preconditions.checkArgument(!status.isOk(), "status must not be OK");
        this.closeListener(status);
        if (notifyClient) {
            if (this.stashedTrailers == null) {
                this.stashedTrailers = new Metadata();
            }
            this.writeStatusToTrailers(status);
            this.sendStreamAbortToClient(status, this.stashedTrailers);
        }
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this.listenerClosed;
    }

    protected abstract void sendStreamAbortToClient(Status var1, Metadata var2);

    private void halfCloseListener() {
        if (this.inboundPhase(AbstractStream.Phase.STATUS) != AbstractStream.Phase.STATUS && !this.listenerClosed) {
            this.closeDeframer();
            this.listener().halfClosed();
        }
    }

    private void closeListener(Status newStatus) {
        if (!this.listenerClosed) {
            this.listenerClosed = true;
            this.closeDeframer();
            this.listener().closed(newStatus);
        }
    }
}

