/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Codec;
import com.google.bigtable.repackaged.io.grpc.Compressor;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Decompressor;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.internal.MessageDeframer;
import com.google.bigtable.repackaged.io.grpc.internal.MessageFramer;
import com.google.bigtable.repackaged.io.grpc.internal.ReadableBuffer;
import com.google.bigtable.repackaged.io.grpc.internal.Stream;
import com.google.bigtable.repackaged.io.grpc.internal.StreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBuffer;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBufferAllocator;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractStream<IdT>
implements Stream {
    public static final int DEFAULT_ONREADY_THRESHOLD = 32768;
    private final MessageFramer framer;
    private final MessageDeframer deframer;
    private Phase inboundPhase = Phase.HEADERS;
    private Phase outboundPhase = Phase.HEADERS;
    private int onReadyThreshold = 32768;
    private int numSentBytesQueued;
    @GuardedBy(value="onReadyLock")
    private boolean allocated;
    private final Object onReadyLock = new Object();
    private volatile DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private volatile CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    AbstractStream(WritableBufferAllocator bufferAllocator, int maxMessageSize) {
        this.framer = new MessageFramer(new FramerSink(), bufferAllocator);
        this.deframer = new MessageDeframer(new DeframerListener(), Codec.Identity.NONE, maxMessageSize);
    }

    @VisibleForTesting
    AbstractStream(MessageFramer framer, MessageDeframer deframer) {
        this.framer = framer;
        this.deframer = deframer;
    }

    protected abstract StreamListener listener();

    @Nullable
    public abstract IdT id();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOnReadyThreshold() {
        Object object = this.onReadyLock;
        synchronized (object) {
            return this.onReadyThreshold;
        }
    }

    @Override
    public void writeMessage(InputStream message) {
        Preconditions.checkNotNull(message);
        this.outboundPhase(Phase.MESSAGE);
        if (!this.framer.isClosed()) {
            this.framer.writePayload(message);
        }
    }

    @Override
    public final void setMessageCompression(boolean enable) {
        this.framer.setMessageCompression(enable);
    }

    @Override
    public final void flush() {
        if (!this.framer.isClosed()) {
            this.framer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() {
        if (this.listener() != null && this.outboundPhase() != Phase.STATUS) {
            Object object = this.onReadyLock;
            synchronized (object) {
                return this.allocated && this.numSentBytesQueued < this.onReadyThreshold;
            }
        }
        return false;
    }

    final void closeFramer() {
        if (!this.framer.isClosed()) {
            this.framer.close();
        }
    }

    public void dispose() {
        this.framer.dispose();
    }

    protected abstract void internalSendFrame(WritableBuffer var1, boolean var2, boolean var3);

    protected abstract void receiveMessage(InputStream var1);

    protected abstract void inboundDeliveryPaused();

    protected abstract void remoteEndClosed();

    protected abstract void returnProcessedBytes(int var1);

    protected abstract void deframeFailed(Throwable var1);

    protected final void closeDeframer() {
        this.deframer.close();
    }

    protected final void deframe(ReadableBuffer frame, boolean endOfStream) {
        try {
            this.deframer.deframe(frame, endOfStream);
        }
        catch (Throwable t) {
            this.deframeFailed(t);
        }
    }

    protected final boolean isDeframerStalled() {
        return this.deframer.isStalled();
    }

    protected final void requestMessagesFromDeframer(int numMessages) {
        try {
            this.deframer.request(numMessages);
        }
        catch (Throwable t) {
            this.deframeFailed(t);
        }
    }

    protected final void setDecompressor(String messageEncoding) {
        Decompressor d = this.decompressorRegistry.lookupDecompressor(messageEncoding);
        Preconditions.checkArgument(d != null, "Unable to find decompressor for message encoding %s", messageEncoding);
        this.deframer.setDecompressor(d);
    }

    @Override
    public final void setDecompressionRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = Preconditions.checkNotNull(registry);
    }

    @Override
    public final void setCompressionRegistry(CompressorRegistry registry) {
        this.compressorRegistry = Preconditions.checkNotNull(registry);
    }

    @Override
    public final Compressor pickCompressor(Iterable<String> messageEncodings) {
        for (String messageEncoding : messageEncodings) {
            Compressor c = this.compressorRegistry.lookupCompressor(messageEncoding);
            if (c == null) continue;
            this.framer.setCompressor(c);
            return c;
        }
        return null;
    }

    protected final DecompressorRegistry decompressorRegistry() {
        return this.decompressorRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onStreamAllocated() {
        Preconditions.checkState(this.listener() != null);
        Object object = this.onReadyLock;
        synchronized (object) {
            Preconditions.checkState(!this.allocated, "Already allocated");
            this.allocated = true;
        }
        this.notifyIfReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onSendingBytes(int numBytes) {
        Object object = this.onReadyLock;
        synchronized (object) {
            this.numSentBytesQueued += numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onSentBytes(int numBytes) {
        boolean doNotify;
        Object object = this.onReadyLock;
        synchronized (object) {
            boolean belowThresholdBefore = this.numSentBytesQueued < this.onReadyThreshold;
            this.numSentBytesQueued -= numBytes;
            boolean belowThresholdAfter = this.numSentBytesQueued < this.onReadyThreshold;
            doNotify = !belowThresholdBefore && belowThresholdAfter;
        }
        if (doNotify) {
            this.notifyIfReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final void notifyIfReady() {
        boolean doNotify = false;
        Object object = this.onReadyLock;
        synchronized (object) {
            doNotify = this.isReady();
        }
        if (doNotify) {
            this.listener().onReady();
        }
    }

    final Phase inboundPhase() {
        return this.inboundPhase;
    }

    final Phase inboundPhase(Phase nextPhase) {
        Phase tmp = this.inboundPhase;
        this.inboundPhase = this.verifyNextPhase(this.inboundPhase, nextPhase);
        return tmp;
    }

    final Phase outboundPhase() {
        return this.outboundPhase;
    }

    final Phase outboundPhase(Phase nextPhase) {
        Phase tmp = this.outboundPhase;
        this.outboundPhase = this.verifyNextPhase(this.outboundPhase, nextPhase);
        return tmp;
    }

    @VisibleForTesting
    Phase verifyNextPhase(Phase currentPhase, Phase nextPhase) {
        if (nextPhase.ordinal() < currentPhase.ordinal()) {
            throw new IllegalStateException(String.format("Cannot transition phase from %s to %s", new Object[]{currentPhase, nextPhase}));
        }
        return nextPhase;
    }

    public boolean canReceive() {
        return this.inboundPhase() != Phase.STATUS;
    }

    public boolean canSend() {
        return this.outboundPhase() != Phase.STATUS;
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.inboundPhase() == Phase.STATUS && this.outboundPhase() == Phase.STATUS;
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("id", this.id()).add("inboundPhase", this.inboundPhase().name()).add("outboundPhase", this.outboundPhase().name());
    }

    @VisibleForTesting
    class DeframerListener
    implements MessageDeframer.Listener {
        DeframerListener() {
        }

        @Override
        public void bytesRead(int numBytes) {
            AbstractStream.this.returnProcessedBytes(numBytes);
        }

        @Override
        public void messageRead(InputStream input) {
            AbstractStream.this.receiveMessage(input);
        }

        @Override
        public void deliveryStalled() {
            AbstractStream.this.inboundDeliveryPaused();
        }

        @Override
        public void endOfStream() {
            AbstractStream.this.remoteEndClosed();
        }
    }

    @VisibleForTesting
    class FramerSink
    implements MessageFramer.Sink {
        FramerSink() {
        }

        @Override
        public void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
            AbstractStream.this.internalSendFrame(frame, endOfStream, flush);
        }
    }

    protected static enum Phase {
        HEADERS,
        MESSAGE,
        STATUS;

    }
}

