/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptors;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.ResolvedServerInfo;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.TransportManager;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.ClientCallImpl;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransportFactory;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import com.google.bigtable.repackaged.io.grpc.internal.TransportSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ManagedChannelImpl
extends ManagedChannel {
    private static final Logger log = Logger.getLogger(ManagedChannelImpl.class.getName());
    private static final ListenableFuture<ClientTransport> NULL_VALUE_TRANSPORT_FUTURE = Futures.immediateFuture(null);
    private static final Pattern URI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-.]*:/.*");
    private final ClientTransportFactory transportFactory;
    private final Executor executor;
    private final boolean usingSharedExecutor;
    private final String userAgent;
    private final Object lock = new Object();
    private final Set<String> knownAcceptEncodingRegistry = Collections.newSetFromMap(new ConcurrentHashMap());
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private ScheduledExecutorService scheduledExecutor;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Channel interceptorChannel;
    private final NameResolver nameResolver;
    private final LoadBalancer loadBalancer;
    @GuardedBy(value="lock")
    private final Map<EquivalentAddressGroup, TransportSet> transports = new HashMap<EquivalentAddressGroup, TransportSet>();
    @GuardedBy(value="lock")
    private boolean shutdown;
    @GuardedBy(value="lock")
    private boolean terminated;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<ClientTransport> get(CallOptions callOptions) {
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                if (ManagedChannelImpl.this.shutdown) {
                    return NULL_VALUE_TRANSPORT_FUTURE;
                }
            }
            return ManagedChannelImpl.this.loadBalancer.pickTransport(callOptions.getRequestKey());
        }
    };
    private final TransportManager tm = new TransportManager(){

        @Override
        public void updateRetainedTransports(Collection<EquivalentAddressGroup> addrs) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<ClientTransport> getTransport(final EquivalentAddressGroup addressGroup) {
            TransportSet ts;
            Preconditions.checkNotNull(addressGroup, "addressGroup");
            Object object = ManagedChannelImpl.this.lock;
            synchronized (object) {
                if (ManagedChannelImpl.this.shutdown) {
                    return NULL_VALUE_TRANSPORT_FUTURE;
                }
                ts = (TransportSet)ManagedChannelImpl.this.transports.get(addressGroup);
                if (ts == null) {
                    ts = new TransportSet(addressGroup, ManagedChannelImpl.this.authority(), ManagedChannelImpl.this.loadBalancer, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, ManagedChannelImpl.this.scheduledExecutor, new TransportSet.Callback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onTerminated() {
                            Object object = ManagedChannelImpl.this.lock;
                            synchronized (object) {
                                ManagedChannelImpl.this.transports.remove(addressGroup);
                                if (ManagedChannelImpl.this.shutdown && ManagedChannelImpl.this.transports.isEmpty()) {
                                    if (ManagedChannelImpl.this.terminated) {
                                        log.warning("transportTerminated called after already terminated");
                                    }
                                    ManagedChannelImpl.this.terminated = true;
                                    ManagedChannelImpl.this.lock.notifyAll();
                                    ManagedChannelImpl.this.onChannelTerminated();
                                }
                            }
                        }
                    });
                    ManagedChannelImpl.this.transports.put(addressGroup, ts);
                }
            }
            return ts.obtainActiveTransport();
        }
    };

    ManagedChannelImpl(String target, BackoffPolicy.Provider backoffPolicyProvider, NameResolver.Factory nameResolverFactory, Attributes nameResolverParams, LoadBalancer.Factory loadBalancerFactory, ClientTransportFactory transportFactory, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, @Nullable Executor executor, @Nullable String userAgent, List<ClientInterceptor> interceptors) {
        if (executor == null) {
            this.usingSharedExecutor = true;
            this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        } else {
            this.usingSharedExecutor = false;
            this.executor = executor;
        }
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.nameResolver = ManagedChannelImpl.getNameResolver(target, nameResolverFactory, nameResolverParams);
        this.loadBalancer = loadBalancerFactory.newLoadBalancer(this.nameResolver.getServiceAuthority(), this.tm);
        this.transportFactory = transportFactory;
        this.userAgent = userAgent;
        this.interceptorChannel = ClientInterceptors.intercept((Channel)new RealChannel(), interceptors);
        this.scheduledExecutor = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        this.nameResolver.start(new NameResolver.Listener(){

            @Override
            public void onUpdate(List<ResolvedServerInfo> servers, Attributes config) {
                ManagedChannelImpl.this.loadBalancer.handleResolvedAddresses(servers, config);
            }

            @Override
            public void onError(Status error) {
                Preconditions.checkArgument(!error.isOk(), "the error status must not be OK");
                ManagedChannelImpl.this.loadBalancer.handleNameResolutionError(error);
            }
        });
    }

    @VisibleForTesting
    static NameResolver getNameResolver(String target, NameResolver.Factory nameResolverFactory, Attributes nameResolverParams) {
        NameResolver resolver;
        URI targetUri = null;
        StringBuilder uriSyntaxErrors = new StringBuilder();
        try {
            targetUri = new URI(target);
        }
        catch (URISyntaxException e) {
            uriSyntaxErrors.append(e.getMessage());
        }
        if (targetUri != null && (resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverParams)) != null) {
            return resolver;
        }
        if (!URI_PATTERN.matcher(target).matches()) {
            try {
                targetUri = new URI(nameResolverFactory.getDefaultScheme(), null, "/" + target, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            if (targetUri != null && (resolver = nameResolverFactory.newNameResolver(targetUri, nameResolverParams)) != null) {
                return resolver;
            }
        }
        throw new IllegalArgumentException(String.format("cannot find a NameResolver for %s%s", target, uriSyntaxErrors.length() > 0 ? " (" + uriSyntaxErrors.toString() + ")" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedChannelImpl shutdown() {
        ArrayList<TransportSet> transportsCopy = new ArrayList<TransportSet>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            this.scheduledExecutor = SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.scheduledExecutor);
            if (this.transports.isEmpty()) {
                this.terminated = true;
                this.lock.notifyAll();
                this.onChannelTerminated();
            } else {
                transportsCopy.addAll(this.transports.values());
            }
        }
        this.loadBalancer.shutdown();
        this.nameResolver.shutdown();
        for (TransportSet ts : transportsCopy) {
            ts.shutdown();
        }
        return this;
    }

    @Override
    public ManagedChannelImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
        return this.interceptorChannel.newCall(method, callOptions);
    }

    @Override
    public String authority() {
        return this.interceptorChannel.authority();
    }

    private void onChannelTerminated() {
        if (this.usingSharedExecutor) {
            SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, (ExecutorService)this.executor);
        }
        this.transportFactory.release();
    }

    private class RealChannel
    extends Channel {
        private RealChannel() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions) {
            return new ClientCallImpl<ReqT, RespT>(method, ManagedChannelImpl.this.executor, callOptions, ManagedChannelImpl.this.transportProvider, ManagedChannelImpl.this.scheduledExecutor).setUserAgent(ManagedChannelImpl.this.userAgent).setDecompressorRegistry(ManagedChannelImpl.this.decompressorRegistry).setCompressorRegistry(ManagedChannelImpl.this.compressorRegistry).setKnownMessageEncodingRegistry(ManagedChannelImpl.this.knownAcceptEncodingRegistry);
        }

        @Override
        public String authority() {
            String authority = ManagedChannelImpl.this.nameResolver.getServiceAuthority();
            return Preconditions.checkNotNull(authority, "authority");
        }
    }
}

