/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.HandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.ServerCall;
import com.google.bigtable.repackaged.io.grpc.ServerMethodDefinition;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ContextRunnable;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import com.google.bigtable.repackaged.io.grpc.internal.SerializingExecutor;
import com.google.bigtable.repackaged.io.grpc.internal.Server;
import com.google.bigtable.repackaged.io.grpc.internal.ServerCallImpl;
import com.google.bigtable.repackaged.io.grpc.internal.ServerListener;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStream;
import com.google.bigtable.repackaged.io.grpc.internal.ServerStreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransportListener;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ServerImpl
extends com.google.bigtable.repackaged.io.grpc.Server {
    private static final ServerStreamListener NOOP_LISTENER = new NoopListener();
    private static final Future<?> DEFAULT_TIMEOUT_FUTURE = Futures.immediateCancelledFuture();
    private static final TimeoutException TIMEOUT_EXCEPTION = new TimeoutException("request timed out"){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private Executor executor;
    private boolean usingSharedExecutor;
    private final HandlerRegistry registry;
    private boolean started;
    private boolean shutdown;
    private boolean terminated;
    private final Server transportServer;
    private final Object lock = new Object();
    private boolean transportServerTerminated;
    private final Collection<ServerTransport> transports = new HashSet<ServerTransport>();
    private final ScheduledExecutorService timeoutService = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
    private final Context rootContext;

    ServerImpl(Executor executor, HandlerRegistry registry, Server transportServer, Context rootContext) {
        this.executor = executor;
        this.registry = Preconditions.checkNotNull(registry, "registry");
        this.transportServer = Preconditions.checkNotNull(transportServer, "transportServer");
        this.rootContext = Preconditions.checkNotNull(rootContext).fork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerImpl start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(!this.started, "Already started");
            Preconditions.checkState(!this.shutdown, "Shutting down");
            boolean bl = this.usingSharedExecutor = this.executor == null;
            if (this.usingSharedExecutor) {
                this.executor = SharedResourceHolder.get(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            }
            this.transportServer.start(new ServerListenerImpl());
            this.started = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerImpl shutdown() {
        boolean shutdownTransportServer;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            shutdownTransportServer = this.started;
            if (!shutdownTransportServer) {
                this.transportServerTerminated = true;
                this.checkForTermination();
            }
        }
        if (shutdownTransportServer) {
            this.transportServer.shutdown();
        }
        SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timeoutService);
        if (this.usingSharedExecutor) {
            SharedResourceHolder.release(GrpcUtil.SHARED_CHANNEL_EXECUTOR, (ExecutorService)this.executor);
        }
        return this;
    }

    @Override
    public ServerImpl shutdownNow() {
        this.shutdown();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long timeoutNanos = unit.toNanos(timeout);
            long endTimeNanos = System.nanoTime() + timeoutNanos;
            while (!this.terminated && (timeoutNanos = endTimeNanos - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, timeoutNanos);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitTermination() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.terminated) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transportClosed(ServerTransport transport) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.transports.remove(transport)) {
                throw new AssertionError((Object)"Transport already removed");
            }
            this.checkForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForTermination() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown && this.transports.isEmpty() && this.transportServerTerminated) {
                if (this.terminated) {
                    throw new AssertionError((Object)"Server already terminated");
                }
                this.terminated = true;
                this.lock.notifyAll();
            }
        }
    }

    private static class JumpToApplicationThreadServerStreamListener
    implements ServerStreamListener {
        private final Executor callExecutor;
        private final Context.CancellableContext context;
        private final ServerStream stream;
        private ServerStreamListener listener;

        public JumpToApplicationThreadServerStreamListener(Executor executor, ServerStream stream, Context.CancellableContext context) {
            this.callExecutor = executor;
            this.stream = stream;
            this.context = context;
        }

        private ServerStreamListener getListener() {
            if (this.listener == null) {
                throw new IllegalStateException("listener unset");
            }
            return this.listener;
        }

        private void setListener(ServerStreamListener listener) {
            Preconditions.checkNotNull(listener, "listener must not be null");
            Preconditions.checkState(this.listener == null, "Listener already set");
            this.listener = listener;
        }

        private void internalClose(Status status, Metadata trailers) {
            this.stream.close(status, trailers);
        }

        @Override
        public void messageRead(final InputStream message) {
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().messageRead(message);
                    }
                    catch (Throwable t) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(t), new Metadata());
                        throw Throwables.propagate(t);
                    }
                }
            });
        }

        @Override
        public void halfClosed() {
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().halfClosed();
                    }
                    catch (Throwable t) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(Status.fromThrowable(t), new Metadata());
                        throw Throwables.propagate(t);
                    }
                }
            });
        }

        @Override
        public void closed(final Status status) {
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().closed(status);
                    }
                    finally {
                        JumpToApplicationThreadServerStreamListener.this.context.cancel(status.getCause());
                    }
                }
            });
        }

        @Override
        public void onReady() {
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    JumpToApplicationThreadServerStreamListener.this.getListener().onReady();
                }
            });
        }
    }

    private static class NoopListener
    implements ServerStreamListener {
        private NoopListener() {
        }

        @Override
        public void messageRead(InputStream value) {
            try {
                value.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void halfClosed() {
        }

        @Override
        public void closed(Status status) {
        }

        @Override
        public void onReady() {
        }
    }

    private class ServerTransportListenerImpl
    implements ServerTransportListener {
        private final ServerTransport transport;

        public ServerTransportListenerImpl(ServerTransport transport) {
            this.transport = transport;
        }

        @Override
        public void transportTerminated() {
            ServerImpl.this.transportClosed(this.transport);
        }

        @Override
        public ServerStreamListener streamCreated(final ServerStream stream, final String methodName, final Metadata headers) {
            final Context.CancellableContext context = ServerImpl.this.rootContext.withCancellation();
            final Future<?> timeout = this.scheduleTimeout(stream, headers, context);
            Executor wrappedExecutor = ServerImpl.this.executor == MoreExecutors.directExecutor() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(ServerImpl.this.executor);
            final JumpToApplicationThreadServerStreamListener jumpListener = new JumpToApplicationThreadServerStreamListener(wrappedExecutor, stream, context);
            wrappedExecutor.execute(new ContextRunnable(context){

                @Override
                public void runInContext() {
                    ServerStreamListener listener = NOOP_LISTENER;
                    try {
                        ServerMethodDefinition<?, ?> method = ServerImpl.this.registry.lookupMethod(methodName);
                        if (method == null) {
                            stream.close(Status.UNIMPLEMENTED.withDescription("Method not found: " + methodName), new Metadata());
                            timeout.cancel(true);
                            return;
                        }
                        listener = ServerTransportListenerImpl.this.startCall(stream, methodName, method, timeout, headers, context);
                    }
                    catch (Throwable t) {
                        stream.close(Status.fromThrowable(t), new Metadata());
                        timeout.cancel(true);
                        throw Throwables.propagate(t);
                    }
                    finally {
                        jumpListener.setListener(listener);
                    }
                }
            });
            return jumpListener;
        }

        private Future<?> scheduleTimeout(final ServerStream stream, Metadata headers, final Context.CancellableContext context) {
            Long timeoutNanos = headers.get(GrpcUtil.TIMEOUT_KEY);
            if (timeoutNanos == null) {
                return DEFAULT_TIMEOUT_FUTURE;
            }
            return ServerImpl.this.timeoutService.schedule(new Runnable(){

                @Override
                public void run() {
                    stream.cancel(Status.DEADLINE_EXCEEDED);
                    context.cancel(TIMEOUT_EXCEPTION);
                }
            }, (long)timeoutNanos, TimeUnit.NANOSECONDS);
        }

        private <ReqT, RespT> ServerStreamListener startCall(ServerStream stream, String fullMethodName, ServerMethodDefinition<ReqT, RespT> methodDef, Future<?> timeout, Metadata headers, Context.CancellableContext context) {
            ServerCallImpl<ReqT, RespT> call = new ServerCallImpl<ReqT, RespT>(stream, methodDef.getMethodDescriptor(), context);
            ServerCall.Listener<ReqT> listener = methodDef.getServerCallHandler().startCall(methodDef.getMethodDescriptor(), call, headers);
            if (listener == null) {
                throw new NullPointerException("startCall() returned a null listener for method " + fullMethodName);
            }
            return call.newServerStreamListener(listener, timeout);
        }
    }

    private class ServerListenerImpl
    implements ServerListener {
        private ServerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerTransportListener transportCreated(ServerTransport transport) {
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transports.add(transport);
            }
            return new ServerTransportListenerImpl(transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serverShutdown() {
            ArrayList copiedTransports;
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                copiedTransports = new ArrayList(ServerImpl.this.transports);
            }
            for (ServerTransport transport : copiedTransports) {
                transport.shutdown();
            }
            object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transportServerTerminated = true;
                ServerImpl.this.checkForTermination();
            }
        }
    }
}

