/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransportFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TransportSet {
    private static final Logger log = Logger.getLogger(TransportSet.class.getName());
    private static final UncancellableTransportFuture NULL_VALUE_FUTURE = new UncancellableTransportFuture();
    private final Object lock = new Object();
    private final EquivalentAddressGroup addressGroup;
    private final String authority;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Callback callback;
    private final ClientTransportFactory transportFactory;
    private final ScheduledExecutorService scheduledExecutor;
    @GuardedBy(value="lock")
    private int nextAddressIndex;
    @GuardedBy(value="lock")
    private BackoffPolicy reconnectPolicy;
    @GuardedBy(value="lock")
    private int headIndex = -1;
    @GuardedBy(value="lock")
    private final Stopwatch backoffWatch;
    @Nullable
    @GuardedBy(value="lock")
    private ScheduledFuture<?> reconnectTask;
    @GuardedBy(value="lock")
    private final Collection<ClientTransport> transports = new ArrayList<ClientTransport>();
    private final LoadBalancer loadBalancer;
    @GuardedBy(value="lock")
    private boolean shutdown;
    @Nullable
    private volatile UncancellableTransportFuture activeTransportFuture;

    TransportSet(EquivalentAddressGroup addressGroup, String authority, LoadBalancer loadBalancer, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Callback callback) {
        this(addressGroup, authority, loadBalancer, backoffPolicyProvider, transportFactory, scheduledExecutor, callback, Stopwatch.createUnstarted());
    }

    @VisibleForTesting
    TransportSet(EquivalentAddressGroup addressGroup, String authority, LoadBalancer loadBalancer, BackoffPolicy.Provider backoffPolicyProvider, ClientTransportFactory transportFactory, ScheduledExecutorService scheduledExecutor, Callback callback, Stopwatch backoffWatch) {
        this.addressGroup = Preconditions.checkNotNull(addressGroup, "addressGroup");
        this.authority = authority;
        this.loadBalancer = loadBalancer;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.transportFactory = transportFactory;
        this.scheduledExecutor = scheduledExecutor;
        this.callback = callback;
        this.backoffWatch = backoffWatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ListenableFuture<ClientTransport> obtainActiveTransport() {
        UncancellableTransportFuture savedTransportFuture = this.activeTransportFuture;
        if (savedTransportFuture != null) {
            return savedTransportFuture;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.activeTransportFuture == null) {
                Preconditions.checkState(!this.shutdown, "already shutdown");
                Preconditions.checkState(this.activeTransportFuture == null || this.activeTransportFuture.isDone(), "activeTransportFuture is neither null nor done");
                this.activeTransportFuture = new UncancellableTransportFuture();
                this.scheduleConnection();
            }
            return this.activeTransportFuture;
        }
    }

    @GuardedBy(value="lock")
    private void scheduleConnection() {
        long delayMillis;
        Preconditions.checkState(!this.shutdown, "Already shut down");
        Preconditions.checkState(this.reconnectTask == null || this.reconnectTask.isDone(), "previous reconnectTask is not done");
        final int currentAddressIndex = this.nextAddressIndex++;
        List<SocketAddress> addrs = this.addressGroup.getAddresses();
        final SocketAddress address = addrs.get(currentAddressIndex);
        if (this.nextAddressIndex >= addrs.size()) {
            this.nextAddressIndex = 0;
        }
        Runnable createTransportRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TransportSet.this.lock;
                synchronized (object) {
                    if (TransportSet.this.shutdown) {
                        return;
                    }
                    if (currentAddressIndex == TransportSet.this.headIndex) {
                        TransportSet.this.backoffWatch.reset().start();
                    }
                    ClientTransport newActiveTransport = TransportSet.this.transportFactory.newClientTransport(address, TransportSet.this.authority);
                    log.log(Level.INFO, "Created transport {0} for {1}", new Object[]{newActiveTransport, address});
                    TransportSet.this.transports.add(newActiveTransport);
                    newActiveTransport.start(new TransportListener(newActiveTransport, TransportSet.this.activeTransportFuture, address));
                    Preconditions.checkState(TransportSet.this.activeTransportFuture.set(newActiveTransport), "failed to set the new transport to the future");
                }
            }
        };
        if (currentAddressIndex == this.headIndex) {
            delayMillis = this.reconnectPolicy.nextBackoffMillis() - this.backoffWatch.elapsed(TimeUnit.MILLISECONDS);
        } else {
            delayMillis = 0L;
            if (this.headIndex == -1) {
                this.headIndex = currentAddressIndex;
                this.reconnectPolicy = this.backoffPolicyProvider.get();
            }
        }
        if (delayMillis <= 0L) {
            this.reconnectTask = null;
            createTransportRunnable.run();
        } else {
            this.reconnectTask = this.scheduledExecutor.schedule(createTransportRunnable, delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void shutdown() {
        UncancellableTransportFuture savedActiveTransportFuture;
        boolean runCallback = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            savedActiveTransportFuture = this.activeTransportFuture;
            this.activeTransportFuture = NULL_VALUE_FUTURE;
            if (this.transports.isEmpty()) {
                runCallback = true;
            }
            if (this.reconnectTask != null) {
                this.reconnectTask.cancel(false);
            }
        }
        if (savedActiveTransportFuture != null) {
            if (savedActiveTransportFuture.isDone()) {
                try {
                    ((ClientTransport)savedActiveTransportFuture.get()).shutdown();
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            } else {
                savedActiveTransportFuture.set(null);
            }
        }
        if (runCallback) {
            this.callback.onTerminated();
        }
    }

    static {
        NULL_VALUE_FUTURE.set(null);
    }

    private static class UncancellableTransportFuture
    extends AbstractFuture<ClientTransport> {
        private UncancellableTransportFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        protected boolean set(ClientTransport v) {
            return super.set(v);
        }
    }

    static interface Callback {
        public void onTerminated();
    }

    private class TransportListener
    implements ClientTransport.Listener {
        private final SocketAddress address;
        private final ClientTransport transport;
        private final UncancellableTransportFuture transportFuture;

        public TransportListener(ClientTransport transport, UncancellableTransportFuture transportFuture, SocketAddress address) {
            this.transport = transport;
            this.transportFuture = transportFuture;
            this.address = address;
        }

        @GuardedBy(value="lock")
        private boolean isAttachedToActiveTransport() {
            return TransportSet.this.activeTransportFuture == this.transportFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportReady() {
            Object object = TransportSet.this.lock;
            synchronized (object) {
                log.log(Level.INFO, "Transport {0} for {1} is ready", new Object[]{this.transport, this.address});
                Preconditions.checkState(this.transportFuture.isDone(), "the transport future is not done");
                if (this.isAttachedToActiveTransport()) {
                    TransportSet.this.headIndex = -1;
                }
            }
            TransportSet.this.loadBalancer.transportReady(TransportSet.this.addressGroup, this.transport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportShutdown(Status s) {
            Object object = TransportSet.this.lock;
            synchronized (object) {
                log.log(Level.INFO, "Transport {0} for {1} is being shutdown", new Object[]{this.transport, this.address});
                Preconditions.checkState(this.transportFuture.isDone(), "the transport future is not done");
                if (this.isAttachedToActiveTransport()) {
                    TransportSet.this.activeTransportFuture = null;
                }
            }
            TransportSet.this.loadBalancer.transportShutdown(TransportSet.this.addressGroup, this.transport, s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transportTerminated() {
            boolean runCallback = false;
            Object object = TransportSet.this.lock;
            synchronized (object) {
                log.log(Level.INFO, "Transport {0} for {1} is terminated", new Object[]{this.transport, this.address});
                Preconditions.checkState(!this.isAttachedToActiveTransport(), "Listener is still attached to activeTransportFuture. Seems transportTerminated was not called.");
                TransportSet.this.transports.remove(this.transport);
                if (TransportSet.this.shutdown && TransportSet.this.transports.isEmpty()) {
                    runCallback = true;
                }
            }
            if (runCallback) {
                TransportSet.this.callback.onTerminated();
            }
        }
    }
}

