/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientStream;
import java.util.EnumSet;

class CancelStreamCommand {
    private final NettyClientStream stream;
    private final Status reason;

    CancelStreamCommand(NettyClientStream stream, Status reason) {
        this.stream = Preconditions.checkNotNull(stream, "stream");
        Preconditions.checkNotNull(reason);
        Preconditions.checkArgument(EnumSet.of(Status.Code.CANCELLED, Status.Code.DEADLINE_EXCEEDED).contains((Object)reason.getCode()), "Invalid cancellation reason");
        this.reason = reason;
    }

    NettyClientStream stream() {
        return this.stream;
    }

    Status reason() {
        return this.reason;
    }
}

