/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractManagedChannelImplBuilder;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractReferenceCounted;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransportFactory;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcSslContexts;
import com.google.bigtable.repackaged.io.grpc.netty.NegotiationType;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientTransport;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiators;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.socket.nio.NioSocketChannel;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public class NettyChannelBuilder
extends AbstractManagedChannelImplBuilder<NettyChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private ProtocolNegotiator protocolNegotiator;
    private Class<? extends Channel> channelType = NioSocketChannel.class;
    @Nullable
    private EventLoopGroup eventLoopGroup;
    private SslContext sslContext;
    private int flowControlWindow = 0x100000;
    private int maxMessageSize = 0x6400000;
    private int maxHeaderListSize = 8192;

    public static NettyChannelBuilder forAddress(SocketAddress serverAddress) {
        return new NettyChannelBuilder(serverAddress);
    }

    public static NettyChannelBuilder forAddress(String host, int port) {
        return new NettyChannelBuilder(host, port);
    }

    public static NettyChannelBuilder forTarget(String target) {
        return new NettyChannelBuilder(target);
    }

    protected NettyChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    private NettyChannelBuilder(String target) {
        super(target);
    }

    protected NettyChannelBuilder(SocketAddress address) {
        super(address, NettyChannelBuilder.getAuthorityFromAddress(address));
    }

    private static String getAuthorityFromAddress(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            return GrpcUtil.authorityFromHostAndPort(inetAddress.getHostString(), inetAddress.getPort());
        }
        return address.toString();
    }

    public final NettyChannelBuilder channelType(Class<? extends Channel> channelType) {
        this.channelType = Preconditions.checkNotNull(channelType);
        return this;
    }

    public final NettyChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = type;
        return this;
    }

    public final NettyChannelBuilder protocolNegotiator(@Nullable ProtocolNegotiator protocolNegotiator) {
        this.protocolNegotiator = protocolNegotiator;
        return this;
    }

    public final NettyChannelBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public final NettyChannelBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public final NettyChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument(flowControlWindow > 0, "flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    public final NettyChannelBuilder maxMessageSize(int maxMessageSize) {
        Preconditions.checkArgument(maxMessageSize >= 0, "maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public final NettyChannelBuilder maxHeaderListSize(int maxHeaderListSize) {
        Preconditions.checkArgument(maxHeaderListSize > 0, "maxHeaderListSize must be > 0");
        this.maxHeaderListSize = maxHeaderListSize;
        return this;
    }

    @Override
    public final NettyChannelBuilder usePlaintext(boolean skipNegotiation) {
        if (skipNegotiation) {
            this.negotiationType(NegotiationType.PLAINTEXT);
        } else {
            this.negotiationType(NegotiationType.PLAINTEXT_UPGRADE);
        }
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new NettyTransportFactory(this.channelType, this.negotiationType, this.protocolNegotiator, this.sslContext, this.eventLoopGroup, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize);
    }

    @Override
    protected Attributes getNameResolverParams() {
        int defaultPort;
        switch (this.negotiationType) {
            case PLAINTEXT: 
            case PLAINTEXT_UPGRADE: {
                defaultPort = 80;
                break;
            }
            case TLS: {
                defaultPort = 443;
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
            }
        }
        return Attributes.newBuilder().set(NameResolver.Factory.PARAMS_DEFAULT_PORT, defaultPort).build();
    }

    @VisibleForTesting
    static ProtocolNegotiator createProtocolNegotiator(String authority, NegotiationType negotiationType, SslContext sslContext) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                if (sslContext == null) {
                    try {
                        sslContext = GrpcSslContexts.forClient().build();
                    }
                    catch (SSLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return ProtocolNegotiators.tls(sslContext, authority);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
    }

    private static class NettyTransportFactory
    extends AbstractReferenceCounted
    implements ClientTransportFactory {
        private final Class<? extends Channel> channelType;
        private final NegotiationType negotiationType;
        private final ProtocolNegotiator protocolNegotiator;
        private final SslContext sslContext;
        private final EventLoopGroup group;
        private final boolean usingSharedGroup;
        private final int flowControlWindow;
        private final int maxMessageSize;
        private final int maxHeaderListSize;

        private NettyTransportFactory(Class<? extends Channel> channelType, NegotiationType negotiationType, ProtocolNegotiator protocolNegotiator, SslContext sslContext, EventLoopGroup group, int flowControlWindow, int maxMessageSize, int maxHeaderListSize) {
            this.channelType = channelType;
            this.negotiationType = negotiationType;
            this.protocolNegotiator = protocolNegotiator;
            this.sslContext = sslContext;
            this.flowControlWindow = flowControlWindow;
            this.maxMessageSize = maxMessageSize;
            this.maxHeaderListSize = maxHeaderListSize;
            this.usingSharedGroup = group == null;
            this.group = this.usingSharedGroup ? SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP) : group;
        }

        @Override
        public ClientTransport newClientTransport(SocketAddress serverAddress, String authority) {
            ProtocolNegotiator negotiator = this.protocolNegotiator != null ? this.protocolNegotiator : NettyChannelBuilder.createProtocolNegotiator(authority, this.negotiationType, this.sslContext);
            return new NettyClientTransport(serverAddress, this.channelType, this.group, negotiator, this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, authority);
        }

        @Override
        protected void deallocate() {
            if (this.usingSharedGroup) {
                SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, this.group);
            }
        }
    }
}

