/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Ticker;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.netty.CreateStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientHandler;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientStream;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.SendPingCommand;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.netty.bootstrap.Bootstrap;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.netty.channel.ChannelOption;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.socket.nio.NioSocketChannel;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class NettyClientTransport
implements ClientTransport {
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final AsciiString authority;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private ProtocolNegotiator.Handler negotiationHandler;
    private NettyClientHandler handler;
    private Channel channel;
    private ClientTransport.Listener listener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, EventLoopGroup group, ProtocolNegotiator negotiator, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, String authority) {
        this.negotiator = Preconditions.checkNotNull(negotiator, "negotiator");
        this.address = Preconditions.checkNotNull(address, "address");
        this.group = Preconditions.checkNotNull(group, "group");
        this.channelType = Preconditions.checkNotNull(channelType, "channelType");
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.authority = new AsciiString(authority);
    }

    @Override
    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(headers, "headers");
        AsciiString defaultPath = new AsciiString("/" + method.getFullMethodName());
        AsciiString defaultAuthority = new AsciiString((CharSequence)((Object)(headers.containsKey(GrpcUtil.AUTHORITY_KEY) ? (Comparable)((Object)headers.get(GrpcUtil.AUTHORITY_KEY)) : this.authority)));
        headers.removeAll(GrpcUtil.AUTHORITY_KEY);
        Http2Headers http2Headers = Utils.convertClientHeaders(headers, this.negotiationHandler.scheme(), defaultPath, defaultAuthority);
        class StartCallback
        implements Runnable {
            final NettyClientStream clientStream;
            final ChannelFutureListener failureListener;
            final /* synthetic */ Http2Headers val$http2Headers;
            final /* synthetic */ MethodDescriptor val$method;

            StartCallback() {
                this.val$http2Headers = http2Headers;
                this.val$method = methodDescriptor;
                this.clientStream = new NettyClientStream(NettyClientTransport.this.channel, NettyClientTransport.this.handler, this, NettyClientTransport.this.maxMessageSize);
                this.failureListener = new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            clientStream.transportReportStatus(Utils.statusFromThrowable(future.cause()), true, new Metadata());
                        }
                    }
                };
            }

            @Override
            public void run() {
                NettyClientTransport.this.handler.getWriteQueue().enqueue(new CreateStreamCommand(this.val$http2Headers, this.clientStream), !this.val$method.getType().clientSendsOneMessage()).addListener(this.failureListener);
            }
        }
        return (NettyClientTransport)this.new StartCallback().clientStream;
    }

    @Override
    public void start(ClientTransport.Listener transportListener) {
        this.listener = Preconditions.checkNotNull(transportListener, "listener");
        this.handler = this.newHandler();
        this.negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.group(this.group);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, true);
        }
        b.handler(this.negotiationHandler);
        this.channel = b.connect(this.address).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ChannelHandlerContext ctx = NettyClientTransport.this.channel.pipeline().context(NettyClientTransport.this.handler);
                    if (ctx != null) {
                        ctx.fireExceptionCaught(future.cause());
                    }
                    NettyClientTransport.this.channel.pipeline().fireExceptionCaught(future.cause());
                }
            }
        }).channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.write(NettyClientHandler.NOOP_MESSAGE).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        this.channel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                Status status = NettyClientTransport.this.handler.errorStatus();
                if (status == null) {
                    status = Status.INTERNAL.withDescription("Connection closed with unknown cause");
                }
                NettyClientTransport.this.notifyTerminated(status);
            }
        });
    }

    @Override
    public void shutdown() {
        this.notifyShutdown(Status.OK.withDescription("Channel requested transport to shut down"));
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    public String toString() {
        return super.toString() + "(" + this.address + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdown(Status status) {
        boolean notifyShutdown;
        Preconditions.checkNotNull(status, "status");
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            notifyShutdown = !this.shutdown;
            this.shutdown = true;
        }
        if (notifyShutdown) {
            this.listener.transportShutdown(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTerminated(Status status) {
        boolean notifyTerminated;
        this.notifyShutdown(status);
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            notifyTerminated = !this.terminated;
            this.terminated = true;
        }
        if (notifyTerminated) {
            this.listener.transportTerminated();
        }
    }

    private NettyClientHandler newHandler() {
        return NettyClientHandler.newHandler(this.listener, this.flowControlWindow, this.maxHeaderListSize, Ticker.systemTicker());
    }
}

